<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "containers" table
 */
#[Entity]
#[Table(name: "containers")]
class Container extends AbstractEntity
{
    public static array $propertyNames = [
        'containerId' => 'containerId',
        'containerType' => 'containerType',
        'containterName' => 'containterName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $containerId;

    #[Column(type: "integer")]
    private int $containerType;

    #[Column(type: "string", nullable: true)]
    private ?string $containterName;

    public function getContainerId(): int
    {
        return $this->containerId;
    }

    public function setContainerId(int $value): static
    {
        $this->containerId = $value;
        return $this;
    }

    public function getContainerType(): int
    {
        return $this->containerType;
    }

    public function setContainerType(int $value): static
    {
        $this->containerType = $value;
        return $this;
    }

    public function getContainterName(): ?string
    {
        return HtmlDecode($this->containterName);
    }

    public function setContainterName(?string $value): static
    {
        $this->containterName = RemoveXss($value);
        return $this;
    }
}
