<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "containertypes" table
 */
#[Entity]
#[Table(name: "containertypes")]
class Containertype extends AbstractEntity
{
    public static array $propertyNames = [
        'containerTypeId' => 'containerTypeId',
        'containerTypeName' => 'containerTypeName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $containerTypeId;

    #[Column(type: "string")]
    private string $containerTypeName;

    public function getContainerTypeId(): int
    {
        return $this->containerTypeId;
    }

    public function setContainerTypeId(int $value): static
    {
        $this->containerTypeId = $value;
        return $this;
    }

    public function getContainerTypeName(): string
    {
        return HtmlDecode($this->containerTypeName);
    }

    public function setContainerTypeName(string $value): static
    {
        $this->containerTypeName = RemoveXss($value);
        return $this;
    }
}
