<?php

namespace PHPMaker2024\laundrytech;

// Page object
$CustomersAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fcustomersadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomersadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["customername", [fields.customername.visible && fields.customername.required ? ew.Validators.required(fields.customername.caption) : null], fields.customername.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["ParentAgent", [fields.ParentAgent.visible && fields.ParentAgent.required ? ew.Validators.required(fields.ParentAgent.caption) : null, ew.Validators.integer], fields.ParentAgent.isInvalid],
            ["isAgent", [fields.isAgent.visible && fields.isAgent.required ? ew.Validators.required(fields.isAgent.caption) : null, ew.Validators.integer], fields.isAgent.isInvalid],
            ["priceListId", [fields.priceListId.visible && fields.priceListId.required ? ew.Validators.required(fields.priceListId.caption) : null, ew.Validators.integer], fields.priceListId.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["postcode", [fields.postcode.visible && fields.postcode.required ? ew.Validators.required(fields.postcode.caption) : null], fields.postcode.isInvalid],
            ["phone1", [fields.phone1.visible && fields.phone1.required ? ew.Validators.required(fields.phone1.caption) : null], fields.phone1.isInvalid],
            ["phone2", [fields.phone2.visible && fields.phone2.required ? ew.Validators.required(fields.phone2.caption) : null], fields.phone2.isInvalid],
            ["emailaddress", [fields.emailaddress.visible && fields.emailaddress.required ? ew.Validators.required(fields.emailaddress.caption) : null], fields.emailaddress.isInvalid],
            ["notes", [fields.notes.visible && fields.notes.required ? ew.Validators.fileRequired(fields.notes.caption) : null], fields.notes.isInvalid],
            ["customercode", [fields.customercode.visible && fields.customercode.required ? ew.Validators.required(fields.customercode.caption) : null], fields.customercode.isInvalid],
            ["schedule", [fields.schedule.visible && fields.schedule.required ? ew.Validators.required(fields.schedule.caption) : null], fields.schedule.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcustomersadd" id="fcustomersadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customers">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->customername->Visible) { // customername ?>
    <div id="r_customername"<?= $Page->customername->rowAttributes() ?>>
        <label id="elh_customers_customername" for="x_customername" class="<?= $Page->LeftColumnClass ?>"><?= $Page->customername->caption() ?><?= $Page->customername->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->customername->cellAttributes() ?>>
<span id="el_customers_customername">
<input type="<?= $Page->customername->getInputTextType() ?>" name="x_customername" id="x_customername" data-table="customers" data-field="x_customername" value="<?= $Page->customername->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->customername->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->customername->formatPattern()) ?>"<?= $Page->customername->editAttributes() ?> aria-describedby="x_customername_help">
<?= $Page->customername->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->customername->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_customers_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_customers_address">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="customers" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help">
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
    <div id="r_ParentAgent"<?= $Page->ParentAgent->rowAttributes() ?>>
        <label id="elh_customers_ParentAgent" for="x_ParentAgent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ParentAgent->caption() ?><?= $Page->ParentAgent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ParentAgent->cellAttributes() ?>>
<span id="el_customers_ParentAgent">
<input type="<?= $Page->ParentAgent->getInputTextType() ?>" name="x_ParentAgent" id="x_ParentAgent" data-table="customers" data-field="x_ParentAgent" value="<?= $Page->ParentAgent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ParentAgent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ParentAgent->formatPattern()) ?>"<?= $Page->ParentAgent->editAttributes() ?> aria-describedby="x_ParentAgent_help">
<?= $Page->ParentAgent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ParentAgent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->isAgent->Visible) { // isAgent ?>
    <div id="r_isAgent"<?= $Page->isAgent->rowAttributes() ?>>
        <label id="elh_customers_isAgent" for="x_isAgent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->isAgent->caption() ?><?= $Page->isAgent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->isAgent->cellAttributes() ?>>
<span id="el_customers_isAgent">
<input type="<?= $Page->isAgent->getInputTextType() ?>" name="x_isAgent" id="x_isAgent" data-table="customers" data-field="x_isAgent" value="<?= $Page->isAgent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->isAgent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->isAgent->formatPattern()) ?>"<?= $Page->isAgent->editAttributes() ?> aria-describedby="x_isAgent_help">
<?= $Page->isAgent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->isAgent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->priceListId->Visible) { // priceListId ?>
    <div id="r_priceListId"<?= $Page->priceListId->rowAttributes() ?>>
        <label id="elh_customers_priceListId" for="x_priceListId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->priceListId->caption() ?><?= $Page->priceListId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->priceListId->cellAttributes() ?>>
<span id="el_customers_priceListId">
<input type="<?= $Page->priceListId->getInputTextType() ?>" name="x_priceListId" id="x_priceListId" data-table="customers" data-field="x_priceListId" value="<?= $Page->priceListId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->priceListId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->priceListId->formatPattern()) ?>"<?= $Page->priceListId->editAttributes() ?> aria-describedby="x_priceListId_help">
<?= $Page->priceListId->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->priceListId->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_customers_city" for="x_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_customers_city">
<input type="<?= $Page->city->getInputTextType() ?>" name="x_city" id="x_city" data-table="customers" data-field="x_city" value="<?= $Page->city->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?> aria-describedby="x_city_help">
<?= $Page->city->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label id="elh_customers_country" for="x_country" class="<?= $Page->LeftColumnClass ?>"><?= $Page->country->caption() ?><?= $Page->country->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->country->cellAttributes() ?>>
<span id="el_customers_country">
<input type="<?= $Page->country->getInputTextType() ?>" name="x_country" id="x_country" data-table="customers" data-field="x_country" value="<?= $Page->country->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->country->formatPattern()) ?>"<?= $Page->country->editAttributes() ?> aria-describedby="x_country_help">
<?= $Page->country->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->postcode->Visible) { // postcode ?>
    <div id="r_postcode"<?= $Page->postcode->rowAttributes() ?>>
        <label id="elh_customers_postcode" for="x_postcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->postcode->caption() ?><?= $Page->postcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->postcode->cellAttributes() ?>>
<span id="el_customers_postcode">
<input type="<?= $Page->postcode->getInputTextType() ?>" name="x_postcode" id="x_postcode" data-table="customers" data-field="x_postcode" value="<?= $Page->postcode->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->postcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->postcode->formatPattern()) ?>"<?= $Page->postcode->editAttributes() ?> aria-describedby="x_postcode_help">
<?= $Page->postcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->postcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->phone1->Visible) { // phone1 ?>
    <div id="r_phone1"<?= $Page->phone1->rowAttributes() ?>>
        <label id="elh_customers_phone1" for="x_phone1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->phone1->caption() ?><?= $Page->phone1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->phone1->cellAttributes() ?>>
<span id="el_customers_phone1">
<input type="<?= $Page->phone1->getInputTextType() ?>" name="x_phone1" id="x_phone1" data-table="customers" data-field="x_phone1" value="<?= $Page->phone1->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->phone1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->phone1->formatPattern()) ?>"<?= $Page->phone1->editAttributes() ?> aria-describedby="x_phone1_help">
<?= $Page->phone1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->phone1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->phone2->Visible) { // phone2 ?>
    <div id="r_phone2"<?= $Page->phone2->rowAttributes() ?>>
        <label id="elh_customers_phone2" for="x_phone2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->phone2->caption() ?><?= $Page->phone2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->phone2->cellAttributes() ?>>
<span id="el_customers_phone2">
<input type="<?= $Page->phone2->getInputTextType() ?>" name="x_phone2" id="x_phone2" data-table="customers" data-field="x_phone2" value="<?= $Page->phone2->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->phone2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->phone2->formatPattern()) ?>"<?= $Page->phone2->editAttributes() ?> aria-describedby="x_phone2_help">
<?= $Page->phone2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->phone2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emailaddress->Visible) { // emailaddress ?>
    <div id="r_emailaddress"<?= $Page->emailaddress->rowAttributes() ?>>
        <label id="elh_customers_emailaddress" for="x_emailaddress" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emailaddress->caption() ?><?= $Page->emailaddress->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emailaddress->cellAttributes() ?>>
<span id="el_customers_emailaddress">
<input type="<?= $Page->emailaddress->getInputTextType() ?>" name="x_emailaddress" id="x_emailaddress" data-table="customers" data-field="x_emailaddress" value="<?= $Page->emailaddress->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emailaddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emailaddress->formatPattern()) ?>"<?= $Page->emailaddress->editAttributes() ?> aria-describedby="x_emailaddress_help">
<?= $Page->emailaddress->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emailaddress->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->notes->Visible) { // notes ?>
    <div id="r_notes"<?= $Page->notes->rowAttributes() ?>>
        <label id="elh_customers_notes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->notes->caption() ?><?= $Page->notes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->notes->cellAttributes() ?>>
<span id="el_customers_notes">
<div id="fd_x_notes" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_notes"
        name="x_notes"
        class="form-control ew-file-input"
        title="<?= $Page->notes->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="customers"
        data-field="x_notes"
        data-size="65535"
        data-accept-file-types="<?= $Page->notes->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->notes->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->notes->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_notes_help"
        <?= ($Page->notes->ReadOnly || $Page->notes->Disabled) ? " disabled" : "" ?>
        <?= $Page->notes->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->notes->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->notes->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_notes" id= "fn_x_notes" value="<?= $Page->notes->Upload->FileName ?>">
<input type="hidden" name="fa_x_notes" id= "fa_x_notes" value="0">
<table id="ft_x_notes" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->customercode->Visible) { // customercode ?>
    <div id="r_customercode"<?= $Page->customercode->rowAttributes() ?>>
        <label id="elh_customers_customercode" for="x_customercode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->customercode->caption() ?><?= $Page->customercode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->customercode->cellAttributes() ?>>
<span id="el_customers_customercode">
<input type="<?= $Page->customercode->getInputTextType() ?>" name="x_customercode" id="x_customercode" data-table="customers" data-field="x_customercode" value="<?= $Page->customercode->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->customercode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->customercode->formatPattern()) ?>"<?= $Page->customercode->editAttributes() ?> aria-describedby="x_customercode_help">
<?= $Page->customercode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->customercode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->schedule->Visible) { // schedule ?>
    <div id="r_schedule"<?= $Page->schedule->rowAttributes() ?>>
        <label id="elh_customers_schedule" for="x_schedule" class="<?= $Page->LeftColumnClass ?>"><?= $Page->schedule->caption() ?><?= $Page->schedule->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->schedule->cellAttributes() ?>>
<span id="el_customers_schedule">
<input type="<?= $Page->schedule->getInputTextType() ?>" name="x_schedule" id="x_schedule" data-table="customers" data-field="x_schedule" value="<?= $Page->schedule->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->schedule->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule->formatPattern()) ?>"<?= $Page->schedule->editAttributes() ?> aria-describedby="x_schedule_help">
<?= $Page->schedule->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->schedule->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("customerhasarticles", explode(",", $Page->getCurrentDetailTable())) && $customerhasarticles->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("customerhasarticles", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "CustomerhasarticlesGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcustomersadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcustomersadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
