<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class ContainersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/containerslist[/{containerId}]", [PermissionMiddleware::class], "list.containers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/containersadd[/{containerId}]", [PermissionMiddleware::class], "add.containers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/containersview[/{containerId}]", [PermissionMiddleware::class], "view.containers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/containersedit[/{containerId}]", [PermissionMiddleware::class], "edit.containers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/containersdelete[/{containerId}]", [PermissionMiddleware::class], "delete.containers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainersDelete");
    }
}
