<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class DeliverynoteController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/deliverynotelist[/{dnoteID}]", [PermissionMiddleware::class], "list.deliverynote")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DeliverynoteList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/deliverynoteadd[/{dnoteID}]", [PermissionMiddleware::class], "add.deliverynote")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DeliverynoteAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/deliverynoteview[/{dnoteID}]", [PermissionMiddleware::class], "view.deliverynote")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DeliverynoteView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/deliverynoteedit[/{dnoteID}]", [PermissionMiddleware::class], "edit.deliverynote")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DeliverynoteEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/deliverynotedelete[/{dnoteID}]", [PermissionMiddleware::class], "delete.deliverynote")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DeliverynoteDelete");
    }
}
