<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrdersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/orderslist[/{orderid}]", [PermissionMiddleware::class], "list.orders")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ordersadd[/{orderid}]", [PermissionMiddleware::class], "add.orders")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ordersview[/{orderid}]", [PermissionMiddleware::class], "view.orders")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ordersedit[/{orderid}]", [PermissionMiddleware::class], "edit.orders")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ordersdelete[/{orderid}]", [PermissionMiddleware::class], "delete.orders")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdersDelete");
    }
}
