<?php

namespace PHPMaker2024\laundrytech;

// Page object
$ContainersView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fcontainersview" id="fcontainersview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { containers: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcontainersview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcontainersview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="containers">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->containerId->Visible) { // containerId ?>
    <tr id="r_containerId"<?= $Page->containerId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_containers_containerId"><?= $Page->containerId->caption() ?></span></td>
        <td data-name="containerId"<?= $Page->containerId->cellAttributes() ?>>
<span id="el_containers_containerId">
<span<?= $Page->containerId->viewAttributes() ?>>
<?= $Page->containerId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->containerType->Visible) { // containerType ?>
    <tr id="r_containerType"<?= $Page->containerType->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_containers_containerType"><?= $Page->containerType->caption() ?></span></td>
        <td data-name="containerType"<?= $Page->containerType->cellAttributes() ?>>
<span id="el_containers_containerType">
<span<?= $Page->containerType->viewAttributes() ?>>
<?= $Page->containerType->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->containterName->Visible) { // containterName ?>
    <tr id="r_containterName"<?= $Page->containterName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_containers_containterName"><?= $Page->containterName->caption() ?></span></td>
        <td data-name="containterName"<?= $Page->containterName->cellAttributes() ?>>
<span id="el_containers_containterName">
<span<?= $Page->containterName->viewAttributes() ?>>
<?= $Page->containterName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
