<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class ArticlesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/articleslist[/{articleid}]", [PermissionMiddleware::class], "list.articles")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ArticlesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/articlesadd[/{articleid}]", [PermissionMiddleware::class], "add.articles")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ArticlesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/articlesview[/{articleid}]", [PermissionMiddleware::class], "view.articles")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ArticlesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/articlesedit[/{articleid}]", [PermissionMiddleware::class], "edit.articles")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ArticlesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/articlesdelete[/{articleid}]", [PermissionMiddleware::class], "delete.articles")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ArticlesDelete");
    }
}
