<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "cages" table
 */
#[Entity]
#[Table(name: "cages")]
class Cage extends AbstractEntity
{
    public static array $propertyNames = [
        'cageId' => 'cageId',
        'cageNumberName' => 'cageNumberName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $cageId;

    #[Column(type: "string")]
    private string $cageNumberName;

    public function getCageId(): int
    {
        return $this->cageId;
    }

    public function setCageId(int $value): static
    {
        $this->cageId = $value;
        return $this;
    }

    public function getCageNumberName(): string
    {
        return HtmlDecode($this->cageNumberName);
    }

    public function setCageNumberName(string $value): static
    {
        $this->cageNumberName = RemoveXss($value);
        return $this;
    }
}
