<?php
/**
 * PHPMaker 2024 User Level Settings
 */
namespace PHPMaker2024\laundrytech;

/**
 * User levels
 *
 * @var array<int, string>
 * [0] int User level ID
 * [1] string User level name
 */
$USER_LEVELS = [["-2","Anonymous"]];

/**
 * User level permissions
 *
 * @var array<string, int, int>
 * [0] string Project ID + Table name
 * [1] int User level ID
 * [2] int Permissions
 */
$USER_LEVEL_PRIVS = [["{339ED384-28B7-4541-AFCD-FD8488BCC36B}agents","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}articles","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}cages","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}categories","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}customers","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}jobtypes","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}laundrytech_settings","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}laundrytech_users","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}orderdetail","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}orders","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}orderstages","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}ordertypes","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}packagetypes","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}pricelistmaster","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}pricelistsdetails","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}stages","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}customerhasarticles","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}orderarticles","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}userlevelpermissions","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}userlevels","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}laundrytech_uggroups","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}laundrytech_ugmembers","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}laundrytech_ugrights","-2","0"],
    ["{339ED384-28B7-4541-AFCD-FD8488BCC36B}stagegroupassignment","-2","0"]];

/**
 * Tables
 *
 * @var array<string, string, string, bool, string>
 * [0] string Table name
 * [1] string Table variable name
 * [2] string Table caption
 * [3] bool Allowed for update (for userpriv.php)
 * [4] string Project ID
 * [5] string URL (for OthersController::index)
 */
$USER_LEVEL_TABLES = [["agents","agents","agents",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","agentslist"],
    ["articles","articles","articles",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","articleslist"],
    ["cages","cages","cages",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","cageslist"],
    ["categories","categories","categories",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","categorieslist"],
    ["customers","customers","customers",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","customerslist"],
    ["jobtypes","jobtypes","jobtypes",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","jobtypeslist"],
    ["laundrytech_settings","laundrytech_settings","laundrytech settings",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","laundrytechsettingslist"],
    ["laundrytech_users","laundrytech_users","laundrytech users",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","laundrytechuserslist"],
    ["orderdetail","orderdetail","orderdetail",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","orderdetaillist"],
    ["orders","orders","orders",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","orderslist"],
    ["orderstages","orderstages","orderstages",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","orderstageslist"],
    ["ordertypes","ordertypes","ordertypes",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","ordertypeslist"],
    ["packagetypes","packagetypes","packagetypes",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","packagetypeslist"],
    ["pricelistmaster","pricelistmaster","pricelistmaster",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","pricelistmasterlist"],
    ["pricelistsdetails","pricelistsdetails","pricelistsdetails",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","pricelistsdetailslist"],
    ["stages","stages","stages",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","stageslist"],
    ["customerhasarticles","customerhasarticles","customerhasarticles",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","customerhasarticleslist"],
    ["orderarticles","orderarticles","orderarticles",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","orderarticleslist"],
    ["userlevelpermissions","userlevelpermissions","userlevelpermissions",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","userlevelpermissionslist"],
    ["userlevels","userlevels","userlevels",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","userlevelslist"],
    ["laundrytech_uggroups","laundrytech_uggroups","laundrytech uggroups",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","laundrytechuggroupslist"],
    ["laundrytech_ugmembers","laundrytech_ugmembers","laundrytech ugmembers",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","laundrytechugmemberslist"],
    ["laundrytech_ugrights","laundrytech_ugrights","laundrytech ugrights",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","laundrytechugrightslist"],
    ["stagegroupassignment","stagegroupassignment","stagegroupassignment",true,"{339ED384-28B7-4541-AFCD-FD8488BCC36B}","stagegroupassignmentlist"]];
