<?php

namespace PHPMaker2024\laundrytech;

// Set up and run Grid object
$Grid = Container("OrderdetailGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var forderdetailgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { orderdetail: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("forderdetailgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["orderDetailId", [fields.orderDetailId.visible && fields.orderDetailId.required ? ew.Validators.required(fields.orderDetailId.caption) : null], fields.orderDetailId.isInvalid],
            ["orderId", [fields.orderId.visible && fields.orderId.required ? ew.Validators.required(fields.orderId.caption) : null, ew.Validators.integer], fields.orderId.isInvalid],
            ["PackageType", [fields.PackageType.visible && fields.PackageType.required ? ew.Validators.required(fields.PackageType.caption) : null, ew.Validators.integer], fields.PackageType.isInvalid],
            ["NoOfPackages", [fields.NoOfPackages.visible && fields.NoOfPackages.required ? ew.Validators.required(fields.NoOfPackages.caption) : null, ew.Validators.integer], fields.NoOfPackages.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["orderId",false],["PackageType",false],["NoOfPackages",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "PackageType": <?= $Grid->PackageType->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="forderdetailgrid" class="ew-form ew-list-form">
<div id="gmp_orderdetail" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_orderdetailgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->orderDetailId->Visible) { // orderDetailId ?>
        <th data-name="orderDetailId" class="<?= $Grid->orderDetailId->headerCellClass() ?>"><div id="elh_orderdetail_orderDetailId" class="orderdetail_orderDetailId"><?= $Grid->renderFieldHeader($Grid->orderDetailId) ?></div></th>
<?php } ?>
<?php if ($Grid->orderId->Visible) { // orderId ?>
        <th data-name="orderId" class="<?= $Grid->orderId->headerCellClass() ?>"><div id="elh_orderdetail_orderId" class="orderdetail_orderId"><?= $Grid->renderFieldHeader($Grid->orderId) ?></div></th>
<?php } ?>
<?php if ($Grid->PackageType->Visible) { // PackageType ?>
        <th data-name="PackageType" class="<?= $Grid->PackageType->headerCellClass() ?>"><div id="elh_orderdetail_PackageType" class="orderdetail_PackageType"><?= $Grid->renderFieldHeader($Grid->PackageType) ?></div></th>
<?php } ?>
<?php if ($Grid->NoOfPackages->Visible) { // NoOfPackages ?>
        <th data-name="NoOfPackages" class="<?= $Grid->NoOfPackages->headerCellClass() ?>"><div id="elh_orderdetail_NoOfPackages" class="orderdetail_NoOfPackages"><?= $Grid->renderFieldHeader($Grid->NoOfPackages) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->orderDetailId->Visible) { // orderDetailId ?>
        <td data-name="orderDetailId"<?= $Grid->orderDetailId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderDetailId" class="el_orderdetail_orderDetailId"></span>
<input type="hidden" data-table="orderdetail" data-field="x_orderDetailId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderDetailId" id="o<?= $Grid->RowIndex ?>_orderDetailId" value="<?= HtmlEncode($Grid->orderDetailId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderDetailId" class="el_orderdetail_orderDetailId">
<span<?= $Grid->orderDetailId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderDetailId->getDisplayValue($Grid->orderDetailId->EditValue))) ?>"></span>
<input type="hidden" data-table="orderdetail" data-field="x_orderDetailId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderDetailId" id="x<?= $Grid->RowIndex ?>_orderDetailId" value="<?= HtmlEncode($Grid->orderDetailId->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderDetailId" class="el_orderdetail_orderDetailId">
<span<?= $Grid->orderDetailId->viewAttributes() ?>>
<?= $Grid->orderDetailId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderdetail" data-field="x_orderDetailId" data-hidden="1" name="forderdetailgrid$x<?= $Grid->RowIndex ?>_orderDetailId" id="forderdetailgrid$x<?= $Grid->RowIndex ?>_orderDetailId" value="<?= HtmlEncode($Grid->orderDetailId->FormValue) ?>">
<input type="hidden" data-table="orderdetail" data-field="x_orderDetailId" data-hidden="1" data-old name="forderdetailgrid$o<?= $Grid->RowIndex ?>_orderDetailId" id="forderdetailgrid$o<?= $Grid->RowIndex ?>_orderDetailId" value="<?= HtmlEncode($Grid->orderDetailId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="orderdetail" data-field="x_orderDetailId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderDetailId" id="x<?= $Grid->RowIndex ?>_orderDetailId" value="<?= HtmlEncode($Grid->orderDetailId->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->orderId->Visible) { // orderId ?>
        <td data-name="orderId"<?= $Grid->orderId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderId" class="el_orderdetail_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="orderdetail" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="orderdetail" data-field="x_orderId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderId" id="o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderId" class="el_orderdetail_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="orderdetail" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_orderId" class="el_orderdetail_orderId">
<span<?= $Grid->orderId->viewAttributes() ?>>
<?= $Grid->orderId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderdetail" data-field="x_orderId" data-hidden="1" name="forderdetailgrid$x<?= $Grid->RowIndex ?>_orderId" id="forderdetailgrid$x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->FormValue) ?>">
<input type="hidden" data-table="orderdetail" data-field="x_orderId" data-hidden="1" data-old name="forderdetailgrid$o<?= $Grid->RowIndex ?>_orderId" id="forderdetailgrid$o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PackageType->Visible) { // PackageType ?>
        <td data-name="PackageType"<?= $Grid->PackageType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_PackageType" class="el_orderdetail_PackageType">
<?php
if (IsRTL()) {
    $Grid->PackageType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_PackageType" class="ew-auto-suggest">
    <input type="<?= $Grid->PackageType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_PackageType" id="sv_x<?= $Grid->RowIndex ?>_PackageType" value="<?= RemoveHtml($Grid->PackageType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->PackageType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->PackageType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PackageType->formatPattern()) ?>"<?= $Grid->PackageType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="orderdetail" data-field="x_PackageType" data-input="sv_x<?= $Grid->RowIndex ?>_PackageType" data-value-separator="<?= $Grid->PackageType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_PackageType" id="x<?= $Grid->RowIndex ?>_PackageType" value="<?= HtmlEncode($Grid->PackageType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->PackageType->getErrorMessage() ?></div>
<script>
loadjs.ready("forderdetailgrid", function() {
    forderdetailgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_PackageType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->PackageType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.orderdetail.fields.PackageType.autoSuggestOptions));
});
</script>
<?= $Grid->PackageType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_PackageType") ?>
</span>
<input type="hidden" data-table="orderdetail" data-field="x_PackageType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PackageType" id="o<?= $Grid->RowIndex ?>_PackageType" value="<?= HtmlEncode($Grid->PackageType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_PackageType" class="el_orderdetail_PackageType">
<?php
if (IsRTL()) {
    $Grid->PackageType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_PackageType" class="ew-auto-suggest">
    <input type="<?= $Grid->PackageType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_PackageType" id="sv_x<?= $Grid->RowIndex ?>_PackageType" value="<?= RemoveHtml($Grid->PackageType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->PackageType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->PackageType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PackageType->formatPattern()) ?>"<?= $Grid->PackageType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="orderdetail" data-field="x_PackageType" data-input="sv_x<?= $Grid->RowIndex ?>_PackageType" data-value-separator="<?= $Grid->PackageType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_PackageType" id="x<?= $Grid->RowIndex ?>_PackageType" value="<?= HtmlEncode($Grid->PackageType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->PackageType->getErrorMessage() ?></div>
<script>
loadjs.ready("forderdetailgrid", function() {
    forderdetailgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_PackageType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->PackageType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.orderdetail.fields.PackageType.autoSuggestOptions));
});
</script>
<?= $Grid->PackageType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_PackageType") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_PackageType" class="el_orderdetail_PackageType">
<span<?= $Grid->PackageType->viewAttributes() ?>>
<?= $Grid->PackageType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderdetail" data-field="x_PackageType" data-hidden="1" name="forderdetailgrid$x<?= $Grid->RowIndex ?>_PackageType" id="forderdetailgrid$x<?= $Grid->RowIndex ?>_PackageType" value="<?= HtmlEncode($Grid->PackageType->FormValue) ?>">
<input type="hidden" data-table="orderdetail" data-field="x_PackageType" data-hidden="1" data-old name="forderdetailgrid$o<?= $Grid->RowIndex ?>_PackageType" id="forderdetailgrid$o<?= $Grid->RowIndex ?>_PackageType" value="<?= HtmlEncode($Grid->PackageType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NoOfPackages->Visible) { // NoOfPackages ?>
        <td data-name="NoOfPackages"<?= $Grid->NoOfPackages->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_NoOfPackages" class="el_orderdetail_NoOfPackages">
<input type="<?= $Grid->NoOfPackages->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NoOfPackages" id="x<?= $Grid->RowIndex ?>_NoOfPackages" data-table="orderdetail" data-field="x_NoOfPackages" value="<?= $Grid->NoOfPackages->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NoOfPackages->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NoOfPackages->formatPattern()) ?>"<?= $Grid->NoOfPackages->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NoOfPackages->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderdetail" data-field="x_NoOfPackages" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NoOfPackages" id="o<?= $Grid->RowIndex ?>_NoOfPackages" value="<?= HtmlEncode($Grid->NoOfPackages->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_NoOfPackages" class="el_orderdetail_NoOfPackages">
<input type="<?= $Grid->NoOfPackages->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NoOfPackages" id="x<?= $Grid->RowIndex ?>_NoOfPackages" data-table="orderdetail" data-field="x_NoOfPackages" value="<?= $Grid->NoOfPackages->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NoOfPackages->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NoOfPackages->formatPattern()) ?>"<?= $Grid->NoOfPackages->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NoOfPackages->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderdetail_NoOfPackages" class="el_orderdetail_NoOfPackages">
<span<?= $Grid->NoOfPackages->viewAttributes() ?>>
<?= $Grid->NoOfPackages->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderdetail" data-field="x_NoOfPackages" data-hidden="1" name="forderdetailgrid$x<?= $Grid->RowIndex ?>_NoOfPackages" id="forderdetailgrid$x<?= $Grid->RowIndex ?>_NoOfPackages" value="<?= HtmlEncode($Grid->NoOfPackages->FormValue) ?>">
<input type="hidden" data-table="orderdetail" data-field="x_NoOfPackages" data-hidden="1" data-old name="forderdetailgrid$o<?= $Grid->RowIndex ?>_NoOfPackages" id="forderdetailgrid$o<?= $Grid->RowIndex ?>_NoOfPackages" value="<?= HtmlEncode($Grid->NoOfPackages->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["forderdetailgrid","load"], () => forderdetailgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="forderdetailgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("orderdetail");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
