<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrderarticlesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/orderarticleslist[/{orderArticleID}]", [PermissionMiddleware::class], "list.orderarticles")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderarticlesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/orderarticlesadd[/{orderArticleID}]", [PermissionMiddleware::class], "add.orderarticles")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderarticlesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/orderarticlesview[/{orderArticleID}]", [PermissionMiddleware::class], "view.orderarticles")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderarticlesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/orderarticlesedit[/{orderArticleID}]", [PermissionMiddleware::class], "edit.orderarticles")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderarticlesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/orderarticlesdelete[/{orderArticleID}]", [PermissionMiddleware::class], "delete.orderarticles")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderarticlesDelete");
    }
}
