<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrdercontainersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ordercontainerslist[/{orderContainerId}]", [PermissionMiddleware::class], "list.ordercontainers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdercontainersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ordercontainersadd[/{orderContainerId}]", [PermissionMiddleware::class], "add.ordercontainers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdercontainersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ordercontainersview[/{orderContainerId}]", [PermissionMiddleware::class], "view.ordercontainers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdercontainersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ordercontainersedit[/{orderContainerId}]", [PermissionMiddleware::class], "edit.ordercontainers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdercontainersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ordercontainersdelete[/{orderContainerId}]", [PermissionMiddleware::class], "delete.ordercontainers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdercontainersDelete");
    }
}
