<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrdertypesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ordertypeslist[/{ordertypeid}]", [PermissionMiddleware::class], "list.ordertypes")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdertypesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ordertypesadd[/{ordertypeid}]", [PermissionMiddleware::class], "add.ordertypes")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdertypesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ordertypesview[/{ordertypeid}]", [PermissionMiddleware::class], "view.ordertypes")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdertypesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ordertypesedit[/{ordertypeid}]", [PermissionMiddleware::class], "edit.ordertypes")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdertypesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ordertypesdelete[/{ordertypeid}]", [PermissionMiddleware::class], "delete.ordertypes")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrdertypesDelete");
    }
}
