<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class OrderjobsAdd extends Orderjobs
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OrderjobsAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "orderjobsadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->orderjobId->Visible = false;
        $this->orderid->setVisibility();
        $this->jobType->setVisibility();
        $this->noOfPcs->setVisibility();
        $this->notes1->setVisibility();
        $this->notes2->setVisibility();
        $this->notes3->setVisibility();
        $this->createdBy->setVisibility();
        $this->createdOn->setVisibility();
        $this->isComplete->setVisibility();
        $this->completedBy->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'orderjobs';
        $this->TableName = 'orderjobs';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (orderjobs)
        if (!isset($GLOBALS["orderjobs"]) || $GLOBALS["orderjobs"]::class == PROJECT_NAMESPACE . "orderjobs") {
            $GLOBALS["orderjobs"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'orderjobs');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "orderjobsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['orderjobId'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->orderjobId->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("orderjobId") ?? Route("orderjobId")) !== null) {
                $this->orderjobId->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("orderjobslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "orderjobslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "orderjobsview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "orderjobslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "orderjobslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'orderid' first before field var 'x_orderid'
        $val = $CurrentForm->hasValue("orderid") ? $CurrentForm->getValue("orderid") : $CurrentForm->getValue("x_orderid");
        if (!$this->orderid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->orderid->Visible = false; // Disable update for API request
            } else {
                $this->orderid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jobType' first before field var 'x_jobType'
        $val = $CurrentForm->hasValue("jobType") ? $CurrentForm->getValue("jobType") : $CurrentForm->getValue("x_jobType");
        if (!$this->jobType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jobType->Visible = false; // Disable update for API request
            } else {
                $this->jobType->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'noOfPcs' first before field var 'x_noOfPcs'
        $val = $CurrentForm->hasValue("noOfPcs") ? $CurrentForm->getValue("noOfPcs") : $CurrentForm->getValue("x_noOfPcs");
        if (!$this->noOfPcs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->noOfPcs->Visible = false; // Disable update for API request
            } else {
                $this->noOfPcs->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'notes1' first before field var 'x_notes1'
        $val = $CurrentForm->hasValue("notes1") ? $CurrentForm->getValue("notes1") : $CurrentForm->getValue("x_notes1");
        if (!$this->notes1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notes1->Visible = false; // Disable update for API request
            } else {
                $this->notes1->setFormValue($val);
            }
        }

        // Check field name 'notes2' first before field var 'x_notes2'
        $val = $CurrentForm->hasValue("notes2") ? $CurrentForm->getValue("notes2") : $CurrentForm->getValue("x_notes2");
        if (!$this->notes2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notes2->Visible = false; // Disable update for API request
            } else {
                $this->notes2->setFormValue($val);
            }
        }

        // Check field name 'notes3' first before field var 'x_notes3'
        $val = $CurrentForm->hasValue("notes3") ? $CurrentForm->getValue("notes3") : $CurrentForm->getValue("x_notes3");
        if (!$this->notes3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notes3->Visible = false; // Disable update for API request
            } else {
                $this->notes3->setFormValue($val);
            }
        }

        // Check field name 'createdBy' first before field var 'x_createdBy'
        $val = $CurrentForm->hasValue("createdBy") ? $CurrentForm->getValue("createdBy") : $CurrentForm->getValue("x_createdBy");
        if (!$this->createdBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->createdBy->Visible = false; // Disable update for API request
            } else {
                $this->createdBy->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'createdOn' first before field var 'x_createdOn'
        $val = $CurrentForm->hasValue("createdOn") ? $CurrentForm->getValue("createdOn") : $CurrentForm->getValue("x_createdOn");
        if (!$this->createdOn->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->createdOn->Visible = false; // Disable update for API request
            } else {
                $this->createdOn->setFormValue($val, true, $validate);
            }
            $this->createdOn->CurrentValue = UnFormatDateTime($this->createdOn->CurrentValue, $this->createdOn->formatPattern());
        }

        // Check field name 'isComplete' first before field var 'x_isComplete'
        $val = $CurrentForm->hasValue("isComplete") ? $CurrentForm->getValue("isComplete") : $CurrentForm->getValue("x_isComplete");
        if (!$this->isComplete->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->isComplete->Visible = false; // Disable update for API request
            } else {
                $this->isComplete->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'completedBy' first before field var 'x_completedBy'
        $val = $CurrentForm->hasValue("completedBy") ? $CurrentForm->getValue("completedBy") : $CurrentForm->getValue("x_completedBy");
        if (!$this->completedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->completedBy->Visible = false; // Disable update for API request
            } else {
                $this->completedBy->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'orderjobId' first before field var 'x_orderjobId'
        $val = $CurrentForm->hasValue("orderjobId") ? $CurrentForm->getValue("orderjobId") : $CurrentForm->getValue("x_orderjobId");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->orderid->CurrentValue = $this->orderid->FormValue;
        $this->jobType->CurrentValue = $this->jobType->FormValue;
        $this->noOfPcs->CurrentValue = $this->noOfPcs->FormValue;
        $this->notes1->CurrentValue = $this->notes1->FormValue;
        $this->notes2->CurrentValue = $this->notes2->FormValue;
        $this->notes3->CurrentValue = $this->notes3->FormValue;
        $this->createdBy->CurrentValue = $this->createdBy->FormValue;
        $this->createdOn->CurrentValue = $this->createdOn->FormValue;
        $this->createdOn->CurrentValue = UnFormatDateTime($this->createdOn->CurrentValue, $this->createdOn->formatPattern());
        $this->isComplete->CurrentValue = $this->isComplete->FormValue;
        $this->completedBy->CurrentValue = $this->completedBy->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->orderjobId->setDbValue($row['orderjobId']);
        $this->orderid->setDbValue($row['orderid']);
        $this->jobType->setDbValue($row['jobType']);
        $this->noOfPcs->setDbValue($row['noOfPcs']);
        $this->notes1->setDbValue($row['notes1']);
        $this->notes2->setDbValue($row['notes2']);
        $this->notes3->setDbValue($row['notes3']);
        $this->createdBy->setDbValue($row['createdBy']);
        $this->createdOn->setDbValue($row['createdOn']);
        $this->isComplete->setDbValue($row['isComplete']);
        $this->completedBy->setDbValue($row['completedBy']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['orderjobId'] = $this->orderjobId->DefaultValue;
        $row['orderid'] = $this->orderid->DefaultValue;
        $row['jobType'] = $this->jobType->DefaultValue;
        $row['noOfPcs'] = $this->noOfPcs->DefaultValue;
        $row['notes1'] = $this->notes1->DefaultValue;
        $row['notes2'] = $this->notes2->DefaultValue;
        $row['notes3'] = $this->notes3->DefaultValue;
        $row['createdBy'] = $this->createdBy->DefaultValue;
        $row['createdOn'] = $this->createdOn->DefaultValue;
        $row['isComplete'] = $this->isComplete->DefaultValue;
        $row['completedBy'] = $this->completedBy->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // orderjobId
        $this->orderjobId->RowCssClass = "row";

        // orderid
        $this->orderid->RowCssClass = "row";

        // jobType
        $this->jobType->RowCssClass = "row";

        // noOfPcs
        $this->noOfPcs->RowCssClass = "row";

        // notes1
        $this->notes1->RowCssClass = "row";

        // notes2
        $this->notes2->RowCssClass = "row";

        // notes3
        $this->notes3->RowCssClass = "row";

        // createdBy
        $this->createdBy->RowCssClass = "row";

        // createdOn
        $this->createdOn->RowCssClass = "row";

        // isComplete
        $this->isComplete->RowCssClass = "row";

        // completedBy
        $this->completedBy->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // orderjobId
            $this->orderjobId->ViewValue = $this->orderjobId->CurrentValue;

            // orderid
            $this->orderid->ViewValue = $this->orderid->CurrentValue;
            $this->orderid->ViewValue = FormatNumber($this->orderid->ViewValue, $this->orderid->formatPattern());

            // jobType
            $this->jobType->ViewValue = $this->jobType->CurrentValue;
            $this->jobType->ViewValue = FormatNumber($this->jobType->ViewValue, $this->jobType->formatPattern());

            // noOfPcs
            $this->noOfPcs->ViewValue = $this->noOfPcs->CurrentValue;
            $this->noOfPcs->ViewValue = FormatNumber($this->noOfPcs->ViewValue, $this->noOfPcs->formatPattern());

            // notes1
            $this->notes1->ViewValue = $this->notes1->CurrentValue;

            // notes2
            $this->notes2->ViewValue = $this->notes2->CurrentValue;

            // notes3
            $this->notes3->ViewValue = $this->notes3->CurrentValue;

            // createdBy
            $this->createdBy->ViewValue = $this->createdBy->CurrentValue;
            $this->createdBy->ViewValue = FormatNumber($this->createdBy->ViewValue, $this->createdBy->formatPattern());

            // createdOn
            $this->createdOn->ViewValue = $this->createdOn->CurrentValue;
            $this->createdOn->ViewValue = FormatDateTime($this->createdOn->ViewValue, $this->createdOn->formatPattern());

            // isComplete
            $this->isComplete->ViewValue = $this->isComplete->CurrentValue;
            $this->isComplete->ViewValue = FormatNumber($this->isComplete->ViewValue, $this->isComplete->formatPattern());

            // completedBy
            $this->completedBy->ViewValue = $this->completedBy->CurrentValue;
            $this->completedBy->ViewValue = FormatNumber($this->completedBy->ViewValue, $this->completedBy->formatPattern());

            // orderid
            $this->orderid->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";

            // noOfPcs
            $this->noOfPcs->HrefValue = "";

            // notes1
            $this->notes1->HrefValue = "";

            // notes2
            $this->notes2->HrefValue = "";

            // notes3
            $this->notes3->HrefValue = "";

            // createdBy
            $this->createdBy->HrefValue = "";

            // createdOn
            $this->createdOn->HrefValue = "";

            // isComplete
            $this->isComplete->HrefValue = "";

            // completedBy
            $this->completedBy->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // orderid
            $this->orderid->setupEditAttributes();
            $this->orderid->EditValue = $this->orderid->CurrentValue;
            $this->orderid->PlaceHolder = RemoveHtml($this->orderid->caption());
            if (strval($this->orderid->EditValue) != "" && is_numeric($this->orderid->EditValue)) {
                $this->orderid->EditValue = FormatNumber($this->orderid->EditValue, null);
            }

            // jobType
            $this->jobType->setupEditAttributes();
            $this->jobType->EditValue = $this->jobType->CurrentValue;
            $this->jobType->PlaceHolder = RemoveHtml($this->jobType->caption());
            if (strval($this->jobType->EditValue) != "" && is_numeric($this->jobType->EditValue)) {
                $this->jobType->EditValue = FormatNumber($this->jobType->EditValue, null);
            }

            // noOfPcs
            $this->noOfPcs->setupEditAttributes();
            $this->noOfPcs->EditValue = $this->noOfPcs->CurrentValue;
            $this->noOfPcs->PlaceHolder = RemoveHtml($this->noOfPcs->caption());
            if (strval($this->noOfPcs->EditValue) != "" && is_numeric($this->noOfPcs->EditValue)) {
                $this->noOfPcs->EditValue = FormatNumber($this->noOfPcs->EditValue, null);
            }

            // notes1
            $this->notes1->setupEditAttributes();
            if (!$this->notes1->Raw) {
                $this->notes1->CurrentValue = HtmlDecode($this->notes1->CurrentValue);
            }
            $this->notes1->EditValue = HtmlEncode($this->notes1->CurrentValue);
            $this->notes1->PlaceHolder = RemoveHtml($this->notes1->caption());

            // notes2
            $this->notes2->setupEditAttributes();
            if (!$this->notes2->Raw) {
                $this->notes2->CurrentValue = HtmlDecode($this->notes2->CurrentValue);
            }
            $this->notes2->EditValue = HtmlEncode($this->notes2->CurrentValue);
            $this->notes2->PlaceHolder = RemoveHtml($this->notes2->caption());

            // notes3
            $this->notes3->setupEditAttributes();
            if (!$this->notes3->Raw) {
                $this->notes3->CurrentValue = HtmlDecode($this->notes3->CurrentValue);
            }
            $this->notes3->EditValue = HtmlEncode($this->notes3->CurrentValue);
            $this->notes3->PlaceHolder = RemoveHtml($this->notes3->caption());

            // createdBy
            $this->createdBy->setupEditAttributes();
            $this->createdBy->EditValue = $this->createdBy->CurrentValue;
            $this->createdBy->PlaceHolder = RemoveHtml($this->createdBy->caption());
            if (strval($this->createdBy->EditValue) != "" && is_numeric($this->createdBy->EditValue)) {
                $this->createdBy->EditValue = FormatNumber($this->createdBy->EditValue, null);
            }

            // createdOn
            $this->createdOn->setupEditAttributes();
            $this->createdOn->EditValue = HtmlEncode(FormatDateTime($this->createdOn->CurrentValue, $this->createdOn->formatPattern()));
            $this->createdOn->PlaceHolder = RemoveHtml($this->createdOn->caption());

            // isComplete
            $this->isComplete->setupEditAttributes();
            $this->isComplete->EditValue = $this->isComplete->CurrentValue;
            $this->isComplete->PlaceHolder = RemoveHtml($this->isComplete->caption());
            if (strval($this->isComplete->EditValue) != "" && is_numeric($this->isComplete->EditValue)) {
                $this->isComplete->EditValue = FormatNumber($this->isComplete->EditValue, null);
            }

            // completedBy
            $this->completedBy->setupEditAttributes();
            $this->completedBy->EditValue = $this->completedBy->CurrentValue;
            $this->completedBy->PlaceHolder = RemoveHtml($this->completedBy->caption());
            if (strval($this->completedBy->EditValue) != "" && is_numeric($this->completedBy->EditValue)) {
                $this->completedBy->EditValue = FormatNumber($this->completedBy->EditValue, null);
            }

            // Add refer script

            // orderid
            $this->orderid->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";

            // noOfPcs
            $this->noOfPcs->HrefValue = "";

            // notes1
            $this->notes1->HrefValue = "";

            // notes2
            $this->notes2->HrefValue = "";

            // notes3
            $this->notes3->HrefValue = "";

            // createdBy
            $this->createdBy->HrefValue = "";

            // createdOn
            $this->createdOn->HrefValue = "";

            // isComplete
            $this->isComplete->HrefValue = "";

            // completedBy
            $this->completedBy->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->orderid->Visible && $this->orderid->Required) {
                if (!$this->orderid->IsDetailKey && EmptyValue($this->orderid->FormValue)) {
                    $this->orderid->addErrorMessage(str_replace("%s", $this->orderid->caption(), $this->orderid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->orderid->FormValue)) {
                $this->orderid->addErrorMessage($this->orderid->getErrorMessage(false));
            }
            if ($this->jobType->Visible && $this->jobType->Required) {
                if (!$this->jobType->IsDetailKey && EmptyValue($this->jobType->FormValue)) {
                    $this->jobType->addErrorMessage(str_replace("%s", $this->jobType->caption(), $this->jobType->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jobType->FormValue)) {
                $this->jobType->addErrorMessage($this->jobType->getErrorMessage(false));
            }
            if ($this->noOfPcs->Visible && $this->noOfPcs->Required) {
                if (!$this->noOfPcs->IsDetailKey && EmptyValue($this->noOfPcs->FormValue)) {
                    $this->noOfPcs->addErrorMessage(str_replace("%s", $this->noOfPcs->caption(), $this->noOfPcs->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->noOfPcs->FormValue)) {
                $this->noOfPcs->addErrorMessage($this->noOfPcs->getErrorMessage(false));
            }
            if ($this->notes1->Visible && $this->notes1->Required) {
                if (!$this->notes1->IsDetailKey && EmptyValue($this->notes1->FormValue)) {
                    $this->notes1->addErrorMessage(str_replace("%s", $this->notes1->caption(), $this->notes1->RequiredErrorMessage));
                }
            }
            if ($this->notes2->Visible && $this->notes2->Required) {
                if (!$this->notes2->IsDetailKey && EmptyValue($this->notes2->FormValue)) {
                    $this->notes2->addErrorMessage(str_replace("%s", $this->notes2->caption(), $this->notes2->RequiredErrorMessage));
                }
            }
            if ($this->notes3->Visible && $this->notes3->Required) {
                if (!$this->notes3->IsDetailKey && EmptyValue($this->notes3->FormValue)) {
                    $this->notes3->addErrorMessage(str_replace("%s", $this->notes3->caption(), $this->notes3->RequiredErrorMessage));
                }
            }
            if ($this->createdBy->Visible && $this->createdBy->Required) {
                if (!$this->createdBy->IsDetailKey && EmptyValue($this->createdBy->FormValue)) {
                    $this->createdBy->addErrorMessage(str_replace("%s", $this->createdBy->caption(), $this->createdBy->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->createdBy->FormValue)) {
                $this->createdBy->addErrorMessage($this->createdBy->getErrorMessage(false));
            }
            if ($this->createdOn->Visible && $this->createdOn->Required) {
                if (!$this->createdOn->IsDetailKey && EmptyValue($this->createdOn->FormValue)) {
                    $this->createdOn->addErrorMessage(str_replace("%s", $this->createdOn->caption(), $this->createdOn->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->createdOn->FormValue, $this->createdOn->formatPattern())) {
                $this->createdOn->addErrorMessage($this->createdOn->getErrorMessage(false));
            }
            if ($this->isComplete->Visible && $this->isComplete->Required) {
                if (!$this->isComplete->IsDetailKey && EmptyValue($this->isComplete->FormValue)) {
                    $this->isComplete->addErrorMessage(str_replace("%s", $this->isComplete->caption(), $this->isComplete->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->isComplete->FormValue)) {
                $this->isComplete->addErrorMessage($this->isComplete->getErrorMessage(false));
            }
            if ($this->completedBy->Visible && $this->completedBy->Required) {
                if (!$this->completedBy->IsDetailKey && EmptyValue($this->completedBy->FormValue)) {
                    $this->completedBy->addErrorMessage(str_replace("%s", $this->completedBy->caption(), $this->completedBy->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->completedBy->FormValue)) {
                $this->completedBy->addErrorMessage($this->completedBy->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // orderid
        $this->orderid->setDbValueDef($rsnew, $this->orderid->CurrentValue, false);

        // jobType
        $this->jobType->setDbValueDef($rsnew, $this->jobType->CurrentValue, false);

        // noOfPcs
        $this->noOfPcs->setDbValueDef($rsnew, $this->noOfPcs->CurrentValue, false);

        // notes1
        $this->notes1->setDbValueDef($rsnew, $this->notes1->CurrentValue, false);

        // notes2
        $this->notes2->setDbValueDef($rsnew, $this->notes2->CurrentValue, false);

        // notes3
        $this->notes3->setDbValueDef($rsnew, $this->notes3->CurrentValue, false);

        // createdBy
        $this->createdBy->setDbValueDef($rsnew, $this->createdBy->CurrentValue, false);

        // createdOn
        $this->createdOn->setDbValueDef($rsnew, UnFormatDateTime($this->createdOn->CurrentValue, $this->createdOn->formatPattern()), false);

        // isComplete
        $this->isComplete->setDbValueDef($rsnew, $this->isComplete->CurrentValue, false);

        // completedBy
        $this->completedBy->setDbValueDef($rsnew, $this->completedBy->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['orderid'])) { // orderid
            $this->orderid->setFormValue($row['orderid']);
        }
        if (isset($row['jobType'])) { // jobType
            $this->jobType->setFormValue($row['jobType']);
        }
        if (isset($row['noOfPcs'])) { // noOfPcs
            $this->noOfPcs->setFormValue($row['noOfPcs']);
        }
        if (isset($row['notes1'])) { // notes1
            $this->notes1->setFormValue($row['notes1']);
        }
        if (isset($row['notes2'])) { // notes2
            $this->notes2->setFormValue($row['notes2']);
        }
        if (isset($row['notes3'])) { // notes3
            $this->notes3->setFormValue($row['notes3']);
        }
        if (isset($row['createdBy'])) { // createdBy
            $this->createdBy->setFormValue($row['createdBy']);
        }
        if (isset($row['createdOn'])) { // createdOn
            $this->createdOn->setFormValue($row['createdOn']);
        }
        if (isset($row['isComplete'])) { // isComplete
            $this->isComplete->setFormValue($row['isComplete']);
        }
        if (isset($row['completedBy'])) { // completedBy
            $this->completedBy->setFormValue($row['completedBy']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("orderjobslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
