<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "agents" table
 */
#[Entity]
#[Table(name: "agents")]
class Agent extends AbstractEntity
{
    public static array $propertyNames = [
        'agentid' => 'agentid',
        'agentname' => 'agentname',
        'agentaddress' => 'agentaddress',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $agentid;

    #[Column(type: "string")]
    private string $agentname;

    #[Column(type: "string", nullable: true)]
    private ?string $agentaddress;

    public function getAgentid(): int
    {
        return $this->agentid;
    }

    public function setAgentid(int $value): static
    {
        $this->agentid = $value;
        return $this;
    }

    public function getAgentname(): string
    {
        return HtmlDecode($this->agentname);
    }

    public function setAgentname(string $value): static
    {
        $this->agentname = RemoveXss($value);
        return $this;
    }

    public function getAgentaddress(): ?string
    {
        return HtmlDecode($this->agentaddress);
    }

    public function setAgentaddress(?string $value): static
    {
        $this->agentaddress = RemoveXss($value);
        return $this;
    }
}
