<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "laundrytech_uggroups" table
 */
#[Entity]
#[Table(name: "laundrytech_uggroups")]
class LaundrytechUggroup extends AbstractEntity
{
    public static array $propertyNames = [
        'GroupID' => 'groupId',
        'Label' => 'label',
        'Provider' => 'provider',
        'Comment' => 'comment',
    ];

    #[Id]
    #[Column(name: "GroupID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $groupId;

    #[Column(name: "Label", type: "string", nullable: true)]
    private ?string $label;

    #[Column(name: "Provider", type: "string", nullable: true)]
    private ?string $provider;

    #[Column(name: "Comment", type: "text", nullable: true)]
    private ?string $comment;

    public function getGroupId(): int
    {
        return $this->groupId;
    }

    public function setGroupId(int $value): static
    {
        $this->groupId = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getProvider(): ?string
    {
        return HtmlDecode($this->provider);
    }

    public function setProvider(?string $value): static
    {
        $this->provider = RemoveXss($value);
        return $this;
    }

    public function getComment(): ?string
    {
        return HtmlDecode($this->comment);
    }

    public function setComment(?string $value): static
    {
        $this->comment = RemoveXss($value);
        return $this;
    }
}
