<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "orders" table
 */
#[Entity]
#[Table(name: "orders")]
class Order extends AbstractEntity
{
    public static array $propertyNames = [
        'orderid' => 'orderid',
        'customerid' => 'customerid',
        'bookingdatetime' => 'bookingdatetime',
        'dueby' => 'dueby',
        'ordertype' => 'ordertype',
        'invoiced' => 'invoiced',
        'paid' => 'paid',
        'ordervalue' => 'ordervalue',
        'jobType' => 'jobType',
        'createdOn' => 'createdOn',
        'createdBy' => 'createdBy',
        'siteId' => 'siteId',
        'pickupComplete' => 'pickupComplete',
        'pickupDatetime' => 'pickupDatetime',
        'delivered' => 'delivered',
        'entryCompleted' => 'entryCompleted',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderid;

    #[Column(type: "integer")]
    private int $customerid;

    #[Column(type: "datetime")]
    private DateTime $bookingdatetime;

    #[Column(type: "datetime")]
    private DateTime $dueby;

    #[Column(type: "integer", nullable: true)]
    private ?int $ordertype;

    #[Column(type: "integer", nullable: true)]
    private ?int $invoiced;

    #[Column(type: "integer", nullable: true)]
    private ?int $paid;

    #[Column(type: "float", nullable: true)]
    private ?float $ordervalue;

    #[Column(type: "integer", nullable: true)]
    private ?int $jobType;

    #[Column(type: "datetime")]
    private DateTime $createdOn;

    #[Column(type: "integer")]
    private int $createdBy;

    #[Column(type: "integer", nullable: true)]
    private ?int $siteId;

    #[Column(type: "integer", nullable: true)]
    private ?int $pickupComplete;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $pickupDatetime;

    #[Column(type: "string", nullable: true)]
    private ?string $delivered;

    #[Column(type: "string", nullable: true)]
    private ?string $entryCompleted;

    public function getOrderid(): int
    {
        return $this->orderid;
    }

    public function setOrderid(int $value): static
    {
        $this->orderid = $value;
        return $this;
    }

    public function getCustomerid(): int
    {
        return $this->customerid;
    }

    public function setCustomerid(int $value): static
    {
        $this->customerid = $value;
        return $this;
    }

    public function getBookingdatetime(): DateTime
    {
        return $this->bookingdatetime;
    }

    public function setBookingdatetime(DateTime $value): static
    {
        $this->bookingdatetime = $value;
        return $this;
    }

    public function getDueby(): DateTime
    {
        return $this->dueby;
    }

    public function setDueby(DateTime $value): static
    {
        $this->dueby = $value;
        return $this;
    }

    public function getOrdertype(): ?int
    {
        return $this->ordertype;
    }

    public function setOrdertype(?int $value): static
    {
        $this->ordertype = $value;
        return $this;
    }

    public function getInvoiced(): ?int
    {
        return $this->invoiced;
    }

    public function setInvoiced(?int $value): static
    {
        $this->invoiced = $value;
        return $this;
    }

    public function getPaid(): ?int
    {
        return $this->paid;
    }

    public function setPaid(?int $value): static
    {
        $this->paid = $value;
        return $this;
    }

    public function getOrdervalue(): ?float
    {
        return $this->ordervalue;
    }

    public function setOrdervalue(?float $value): static
    {
        $this->ordervalue = $value;
        return $this;
    }

    public function getJobType(): ?int
    {
        return $this->jobType;
    }

    public function setJobType(?int $value): static
    {
        $this->jobType = $value;
        return $this;
    }

    public function getCreatedOn(): DateTime
    {
        return $this->createdOn;
    }

    public function setCreatedOn(DateTime $value): static
    {
        $this->createdOn = $value;
        return $this;
    }

    public function getCreatedBy(): int
    {
        return $this->createdBy;
    }

    public function setCreatedBy(int $value): static
    {
        $this->createdBy = $value;
        return $this;
    }

    public function getSiteId(): ?int
    {
        return $this->siteId;
    }

    public function setSiteId(?int $value): static
    {
        $this->siteId = $value;
        return $this;
    }

    public function getPickupComplete(): ?int
    {
        return $this->pickupComplete;
    }

    public function setPickupComplete(?int $value): static
    {
        $this->pickupComplete = $value;
        return $this;
    }

    public function getPickupDatetime(): ?DateTime
    {
        return $this->pickupDatetime;
    }

    public function setPickupDatetime(?DateTime $value): static
    {
        $this->pickupDatetime = $value;
        return $this;
    }

    public function getDelivered(): ?string
    {
        return HtmlDecode($this->delivered);
    }

    public function setDelivered(?string $value): static
    {
        $this->delivered = RemoveXss($value);
        return $this;
    }

    public function getEntryCompleted(): ?string
    {
        return HtmlDecode($this->entryCompleted);
    }

    public function setEntryCompleted(?string $value): static
    {
        $this->entryCompleted = RemoveXss($value);
        return $this;
    }
}
