<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "orderstages" table
 */
#[Entity]
#[Table(name: "orderstages")]
class Orderstage extends AbstractEntity
{
    public static array $propertyNames = [
        'orderstageid' => 'orderstageid',
        'orderid' => 'orderid',
        'stageid' => 'stageid',
        'userid' => 'userid',
        'orderdatetime' => 'orderdatetime',
        'processedBy' => 'processedBy',
        'stationId' => 'stationId',
        'orderJobId' => 'orderJobId',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderstageid;

    #[Column(type: "integer")]
    private int $orderid;

    #[Column(type: "integer")]
    private int $stageid;

    #[Column(type: "integer")]
    private int $userid;

    #[Column(type: "datetime")]
    private DateTime $orderdatetime;

    #[Column(type: "integer")]
    private int $processedBy;

    #[Column(type: "integer", nullable: true)]
    private ?int $stationId;

    #[Column(type: "integer", nullable: true)]
    private ?int $orderJobId;

    public function getOrderstageid(): int
    {
        return $this->orderstageid;
    }

    public function setOrderstageid(int $value): static
    {
        $this->orderstageid = $value;
        return $this;
    }

    public function getOrderid(): int
    {
        return $this->orderid;
    }

    public function setOrderid(int $value): static
    {
        $this->orderid = $value;
        return $this;
    }

    public function getStageid(): int
    {
        return $this->stageid;
    }

    public function setStageid(int $value): static
    {
        $this->stageid = $value;
        return $this;
    }

    public function getUserid(): int
    {
        return $this->userid;
    }

    public function setUserid(int $value): static
    {
        $this->userid = $value;
        return $this;
    }

    public function getOrderdatetime(): DateTime
    {
        return $this->orderdatetime;
    }

    public function setOrderdatetime(DateTime $value): static
    {
        $this->orderdatetime = $value;
        return $this;
    }

    public function getProcessedBy(): int
    {
        return $this->processedBy;
    }

    public function setProcessedBy(int $value): static
    {
        $this->processedBy = $value;
        return $this;
    }

    public function getStationId(): ?int
    {
        return $this->stationId;
    }

    public function setStationId(?int $value): static
    {
        $this->stationId = $value;
        return $this;
    }

    public function getOrderJobId(): ?int
    {
        return $this->orderJobId;
    }

    public function setOrderJobId(?int $value): static
    {
        $this->orderJobId = $value;
        return $this;
    }
}
