<?php

namespace PHPMaker2024\laundrytech;

// Page object
$ContainersEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fcontainersedit" id="fcontainersedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { containers: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fcontainersedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcontainersedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["containerId", [fields.containerId.visible && fields.containerId.required ? ew.Validators.required(fields.containerId.caption) : null], fields.containerId.isInvalid],
            ["containerType", [fields.containerType.visible && fields.containerType.required ? ew.Validators.required(fields.containerType.caption) : null, ew.Validators.integer], fields.containerType.isInvalid],
            ["containterName", [fields.containterName.visible && fields.containterName.required ? ew.Validators.required(fields.containterName.caption) : null], fields.containterName.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="containers">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->containerId->Visible) { // containerId ?>
    <div id="r_containerId"<?= $Page->containerId->rowAttributes() ?>>
        <label id="elh_containers_containerId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->containerId->caption() ?><?= $Page->containerId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->containerId->cellAttributes() ?>>
<span id="el_containers_containerId">
<span<?= $Page->containerId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->containerId->getDisplayValue($Page->containerId->EditValue))) ?>"></span>
<input type="hidden" data-table="containers" data-field="x_containerId" data-hidden="1" name="x_containerId" id="x_containerId" value="<?= HtmlEncode($Page->containerId->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->containerType->Visible) { // containerType ?>
    <div id="r_containerType"<?= $Page->containerType->rowAttributes() ?>>
        <label id="elh_containers_containerType" for="x_containerType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->containerType->caption() ?><?= $Page->containerType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->containerType->cellAttributes() ?>>
<span id="el_containers_containerType">
<input type="<?= $Page->containerType->getInputTextType() ?>" name="x_containerType" id="x_containerType" data-table="containers" data-field="x_containerType" value="<?= $Page->containerType->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->containerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containerType->formatPattern()) ?>"<?= $Page->containerType->editAttributes() ?> aria-describedby="x_containerType_help">
<?= $Page->containerType->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->containerType->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->containterName->Visible) { // containterName ?>
    <div id="r_containterName"<?= $Page->containterName->rowAttributes() ?>>
        <label id="elh_containers_containterName" for="x_containterName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->containterName->caption() ?><?= $Page->containterName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->containterName->cellAttributes() ?>>
<span id="el_containers_containterName">
<input type="<?= $Page->containterName->getInputTextType() ?>" name="x_containterName" id="x_containterName" data-table="containers" data-field="x_containterName" value="<?= $Page->containterName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->containterName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containterName->formatPattern()) ?>"<?= $Page->containterName->editAttributes() ?> aria-describedby="x_containterName_help">
<?= $Page->containterName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->containterName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcontainersedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcontainersedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("containers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
