<?php

namespace PHPMaker2024\laundrytech;

// Page object
$CustomersView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fcustomersview" id="fcustomersview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcustomersview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomersview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customers">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->customerid->Visible) { // customerid ?>
    <tr id="r_customerid"<?= $Page->customerid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_customerid"><?= $Page->customerid->caption() ?></span></td>
        <td data-name="customerid"<?= $Page->customerid->cellAttributes() ?>>
<span id="el_customers_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<?= $Page->customerid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->customername->Visible) { // customername ?>
    <tr id="r_customername"<?= $Page->customername->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_customername"><?= $Page->customername->caption() ?></span></td>
        <td data-name="customername"<?= $Page->customername->cellAttributes() ?>>
<span id="el_customers_customername">
<span<?= $Page->customername->viewAttributes() ?>>
<?= $Page->customername->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
    <tr id="r_ParentAgent"<?= $Page->ParentAgent->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_ParentAgent"><?= $Page->ParentAgent->caption() ?></span></td>
        <td data-name="ParentAgent"<?= $Page->ParentAgent->cellAttributes() ?>>
<span id="el_customers_ParentAgent">
<span<?= $Page->ParentAgent->viewAttributes() ?>>
<?= $Page->ParentAgent->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->isAgent->Visible) { // isAgent ?>
    <tr id="r_isAgent"<?= $Page->isAgent->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_isAgent"><?= $Page->isAgent->caption() ?></span></td>
        <td data-name="isAgent"<?= $Page->isAgent->cellAttributes() ?>>
<span id="el_customers_isAgent">
<span<?= $Page->isAgent->viewAttributes() ?>>
<?= $Page->isAgent->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->priceListId->Visible) { // priceListId ?>
    <tr id="r_priceListId"<?= $Page->priceListId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_priceListId"><?= $Page->priceListId->caption() ?></span></td>
        <td data-name="priceListId"<?= $Page->priceListId->cellAttributes() ?>>
<span id="el_customers_priceListId">
<span<?= $Page->priceListId->viewAttributes() ?>>
<?= $Page->priceListId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <tr id="r_city"<?= $Page->city->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_city"><?= $Page->city->caption() ?></span></td>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el_customers_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <tr id="r_country"<?= $Page->country->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_country"><?= $Page->country->caption() ?></span></td>
        <td data-name="country"<?= $Page->country->cellAttributes() ?>>
<span id="el_customers_country">
<span<?= $Page->country->viewAttributes() ?>>
<?= $Page->country->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->postcode->Visible) { // postcode ?>
    <tr id="r_postcode"<?= $Page->postcode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_postcode"><?= $Page->postcode->caption() ?></span></td>
        <td data-name="postcode"<?= $Page->postcode->cellAttributes() ?>>
<span id="el_customers_postcode">
<span<?= $Page->postcode->viewAttributes() ?>>
<?= $Page->postcode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->phone1->Visible) { // phone1 ?>
    <tr id="r_phone1"<?= $Page->phone1->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_phone1"><?= $Page->phone1->caption() ?></span></td>
        <td data-name="phone1"<?= $Page->phone1->cellAttributes() ?>>
<span id="el_customers_phone1">
<span<?= $Page->phone1->viewAttributes() ?>>
<?= $Page->phone1->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->phone2->Visible) { // phone2 ?>
    <tr id="r_phone2"<?= $Page->phone2->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_phone2"><?= $Page->phone2->caption() ?></span></td>
        <td data-name="phone2"<?= $Page->phone2->cellAttributes() ?>>
<span id="el_customers_phone2">
<span<?= $Page->phone2->viewAttributes() ?>>
<?= $Page->phone2->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->emailaddress->Visible) { // emailaddress ?>
    <tr id="r_emailaddress"<?= $Page->emailaddress->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_emailaddress"><?= $Page->emailaddress->caption() ?></span></td>
        <td data-name="emailaddress"<?= $Page->emailaddress->cellAttributes() ?>>
<span id="el_customers_emailaddress">
<span<?= $Page->emailaddress->viewAttributes() ?>>
<?= $Page->emailaddress->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->notes->Visible) { // notes ?>
    <tr id="r_notes"<?= $Page->notes->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_notes"><?= $Page->notes->caption() ?></span></td>
        <td data-name="notes"<?= $Page->notes->cellAttributes() ?>>
<span id="el_customers_notes">
<span<?= $Page->notes->viewAttributes() ?>>
<?= GetFileViewTag($Page->notes, $Page->notes->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->customercode->Visible) { // customercode ?>
    <tr id="r_customercode"<?= $Page->customercode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_customercode"><?= $Page->customercode->caption() ?></span></td>
        <td data-name="customercode"<?= $Page->customercode->cellAttributes() ?>>
<span id="el_customers_customercode">
<span<?= $Page->customercode->viewAttributes() ?>>
<?= $Page->customercode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->address1->Visible) { // address1 ?>
    <tr id="r_address1"<?= $Page->address1->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_address1"><?= $Page->address1->caption() ?></span></td>
        <td data-name="address1"<?= $Page->address1->cellAttributes() ?>>
<span id="el_customers_address1">
<span<?= $Page->address1->viewAttributes() ?>>
<?= $Page->address1->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->runid->Visible) { // runid ?>
    <tr id="r_runid"<?= $Page->runid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_runid"><?= $Page->runid->caption() ?></span></td>
        <td data-name="runid"<?= $Page->runid->cellAttributes() ?>>
<span id="el_customers_runid">
<span<?= $Page->runid->viewAttributes() ?>>
<?= $Page->runid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->contactperson->Visible) { // contactperson ?>
    <tr id="r_contactperson"<?= $Page->contactperson->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_contactperson"><?= $Page->contactperson->caption() ?></span></td>
        <td data-name="contactperson"<?= $Page->contactperson->cellAttributes() ?>>
<span id="el_customers_contactperson">
<span<?= $Page->contactperson->viewAttributes() ?>>
<?= $Page->contactperson->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->address2->Visible) { // address2 ?>
    <tr id="r_address2"<?= $Page->address2->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_address2"><?= $Page->address2->caption() ?></span></td>
        <td data-name="address2"<?= $Page->address2->cellAttributes() ?>>
<span id="el_customers_address2">
<span<?= $Page->address2->viewAttributes() ?>>
<?= $Page->address2->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("customerhasarticles", explode(",", $Page->getCurrentDetailTable())) && $customerhasarticles->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("customerhasarticles", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "CustomerhasarticlesGrid.php" ?>
<?php } ?>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
