<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class DriversController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/driverslist[/{driverId}]", [PermissionMiddleware::class], "list.drivers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DriversList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/driversadd[/{driverId}]", [PermissionMiddleware::class], "add.drivers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DriversAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/driversview[/{driverId}]", [PermissionMiddleware::class], "view.drivers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DriversView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/driversedit[/{driverId}]", [PermissionMiddleware::class], "edit.drivers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DriversEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/driversdelete[/{driverId}]", [PermissionMiddleware::class], "delete.drivers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DriversDelete");
    }
}
