<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class LaundrytechUggroupsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuggroupslist[/{GroupID}]", [PermissionMiddleware::class], "list.laundrytech_uggroups")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUggroupsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuggroupsadd[/{GroupID}]", [PermissionMiddleware::class], "add.laundrytech_uggroups")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUggroupsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuggroupsview[/{GroupID}]", [PermissionMiddleware::class], "view.laundrytech_uggroups")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUggroupsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuggroupsedit[/{GroupID}]", [PermissionMiddleware::class], "edit.laundrytech_uggroups")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUggroupsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuggroupsdelete[/{GroupID}]", [PermissionMiddleware::class], "delete.laundrytech_uggroups")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUggroupsDelete");
    }
}
