<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "drivers" table
 */
#[Entity]
#[Table(name: "drivers")]
class Driver extends AbstractEntity
{
    public static array $propertyNames = [
        'driverId' => 'driverId',
        'driverName' => 'driverName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $driverId;

    #[Column(type: "string")]
    private string $driverName;

    public function getDriverId(): int
    {
        return $this->driverId;
    }

    public function setDriverId(int $value): static
    {
        $this->driverId = $value;
        return $this;
    }

    public function getDriverName(): string
    {
        return HtmlDecode($this->driverName);
    }

    public function setDriverName(string $value): static
    {
        $this->driverName = RemoveXss($value);
        return $this;
    }
}
