<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "stagegroupassignment" table
 */
#[Entity]
#[Table(name: "stagegroupassignment")]
class Stagegroupassignment extends AbstractEntity
{
    public static array $propertyNames = [
        'stageRoleId' => 'stageRoleId',
        'stageId' => 'stageId',
        'groupId' => 'groupId',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $stageRoleId;

    #[Column(type: "integer")]
    private int $stageId;

    #[Column(type: "integer")]
    private int $groupId;

    public function getStageRoleId(): int
    {
        return $this->stageRoleId;
    }

    public function setStageRoleId(int $value): static
    {
        $this->stageRoleId = $value;
        return $this;
    }

    public function getStageId(): int
    {
        return $this->stageId;
    }

    public function setStageId(int $value): static
    {
        $this->stageId = $value;
        return $this;
    }

    public function getGroupId(): int
    {
        return $this->groupId;
    }

    public function setGroupId(int $value): static
    {
        $this->groupId = $value;
        return $this;
    }
}
