<?php

namespace PHPMaker2024\laundrytech;

// Page object
$OrdersView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fordersview" id="fordersview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { orders: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fordersview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fordersview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="orders">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->orderid->Visible) { // orderid ?>
    <tr id="r_orderid"<?= $Page->orderid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_orderid"><?= $Page->orderid->caption() ?></span></td>
        <td data-name="orderid"<?= $Page->orderid->cellAttributes() ?>>
<span id="el_orders_orderid">
<span<?= $Page->orderid->viewAttributes() ?>>
<?= $Page->orderid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->customerid->Visible) { // customerid ?>
    <tr id="r_customerid"<?= $Page->customerid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_customerid"><?= $Page->customerid->caption() ?></span></td>
        <td data-name="customerid"<?= $Page->customerid->cellAttributes() ?>>
<span id="el_orders_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<?= $Page->customerid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->bookingdatetime->Visible) { // bookingdatetime ?>
    <tr id="r_bookingdatetime"<?= $Page->bookingdatetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_bookingdatetime"><?= $Page->bookingdatetime->caption() ?></span></td>
        <td data-name="bookingdatetime"<?= $Page->bookingdatetime->cellAttributes() ?>>
<span id="el_orders_bookingdatetime">
<span<?= $Page->bookingdatetime->viewAttributes() ?>>
<?= $Page->bookingdatetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->dueby->Visible) { // dueby ?>
    <tr id="r_dueby"<?= $Page->dueby->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_dueby"><?= $Page->dueby->caption() ?></span></td>
        <td data-name="dueby"<?= $Page->dueby->cellAttributes() ?>>
<span id="el_orders_dueby">
<span<?= $Page->dueby->viewAttributes() ?>>
<?= $Page->dueby->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ordertype->Visible) { // ordertype ?>
    <tr id="r_ordertype"<?= $Page->ordertype->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_ordertype"><?= $Page->ordertype->caption() ?></span></td>
        <td data-name="ordertype"<?= $Page->ordertype->cellAttributes() ?>>
<span id="el_orders_ordertype">
<span<?= $Page->ordertype->viewAttributes() ?>>
<?= $Page->ordertype->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->invoiced->Visible) { // invoiced ?>
    <tr id="r_invoiced"<?= $Page->invoiced->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_invoiced"><?= $Page->invoiced->caption() ?></span></td>
        <td data-name="invoiced"<?= $Page->invoiced->cellAttributes() ?>>
<span id="el_orders_invoiced">
<span<?= $Page->invoiced->viewAttributes() ?>>
<?= $Page->invoiced->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->paid->Visible) { // paid ?>
    <tr id="r_paid"<?= $Page->paid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_paid"><?= $Page->paid->caption() ?></span></td>
        <td data-name="paid"<?= $Page->paid->cellAttributes() ?>>
<span id="el_orders_paid">
<span<?= $Page->paid->viewAttributes() ?>>
<?= $Page->paid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ordervalue->Visible) { // ordervalue ?>
    <tr id="r_ordervalue"<?= $Page->ordervalue->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_ordervalue"><?= $Page->ordervalue->caption() ?></span></td>
        <td data-name="ordervalue"<?= $Page->ordervalue->cellAttributes() ?>>
<span id="el_orders_ordervalue">
<span<?= $Page->ordervalue->viewAttributes() ?>>
<?= $Page->ordervalue->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->jobType->Visible) { // jobType ?>
    <tr id="r_jobType"<?= $Page->jobType->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_jobType"><?= $Page->jobType->caption() ?></span></td>
        <td data-name="jobType"<?= $Page->jobType->cellAttributes() ?>>
<span id="el_orders_jobType">
<span<?= $Page->jobType->viewAttributes() ?>>
<?= $Page->jobType->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->createdOn->Visible) { // createdOn ?>
    <tr id="r_createdOn"<?= $Page->createdOn->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_createdOn"><?= $Page->createdOn->caption() ?></span></td>
        <td data-name="createdOn"<?= $Page->createdOn->cellAttributes() ?>>
<span id="el_orders_createdOn">
<span<?= $Page->createdOn->viewAttributes() ?>>
<?= $Page->createdOn->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->createdBy->Visible) { // createdBy ?>
    <tr id="r_createdBy"<?= $Page->createdBy->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_createdBy"><?= $Page->createdBy->caption() ?></span></td>
        <td data-name="createdBy"<?= $Page->createdBy->cellAttributes() ?>>
<span id="el_orders_createdBy">
<span<?= $Page->createdBy->viewAttributes() ?>>
<?= $Page->createdBy->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->siteId->Visible) { // siteId ?>
    <tr id="r_siteId"<?= $Page->siteId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_siteId"><?= $Page->siteId->caption() ?></span></td>
        <td data-name="siteId"<?= $Page->siteId->cellAttributes() ?>>
<span id="el_orders_siteId">
<span<?= $Page->siteId->viewAttributes() ?>>
<?= $Page->siteId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->pickupComplete->Visible) { // pickupComplete ?>
    <tr id="r_pickupComplete"<?= $Page->pickupComplete->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_pickupComplete"><?= $Page->pickupComplete->caption() ?></span></td>
        <td data-name="pickupComplete"<?= $Page->pickupComplete->cellAttributes() ?>>
<span id="el_orders_pickupComplete">
<span<?= $Page->pickupComplete->viewAttributes() ?>>
<?= $Page->pickupComplete->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->pickupDatetime->Visible) { // pickupDatetime ?>
    <tr id="r_pickupDatetime"<?= $Page->pickupDatetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_orders_pickupDatetime"><?= $Page->pickupDatetime->caption() ?></span></td>
        <td data-name="pickupDatetime"<?= $Page->pickupDatetime->cellAttributes() ?>>
<span id="el_orders_pickupDatetime">
<span<?= $Page->pickupDatetime->viewAttributes() ?>>
<?= $Page->pickupDatetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("ordercontainers", explode(",", $Page->getCurrentDetailTable())) && $ordercontainers->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("ordercontainers", "TblCaption") ?>&nbsp;<?= str_replace("%s", "orange", str_replace("%c", Container("ordercontainers")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "OrdercontainersGrid.php" ?>
<?php } ?>
<?php
    if (in_array("orderstages", explode(",", $Page->getCurrentDetailTable())) && $orderstages->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("orderstages", "TblCaption") ?>&nbsp;<?= str_replace("%s", "orange", str_replace("%c", Container("orderstages")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "OrderstagesGrid.php" ?>
<?php } ?>
<?php
    if (in_array("orderarticles", explode(",", $Page->getCurrentDetailTable())) && $orderarticles->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("orderarticles", "TblCaption") ?>&nbsp;<?= str_replace("%s", "orange", str_replace("%c", Container("orderarticles")->Count, $Language->phrase("DetailCount"))) ?></h4>
<?php } ?>
<?php include_once "OrderarticlesGrid.php" ?>
<?php } ?>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
