<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CustomersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/customerslist[/{customerid}]", [PermissionMiddleware::class], "list.customers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/customersadd[/{customerid}]", [PermissionMiddleware::class], "add.customers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/customersview[/{customerid}]", [PermissionMiddleware::class], "view.customers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/customersedit[/{customerid}]", [PermissionMiddleware::class], "edit.customers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/customersdelete[/{customerid}]", [PermissionMiddleware::class], "delete.customers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersDelete");
    }
}
