<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CustomersitesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/customersiteslist[/{siteId}]", [PermissionMiddleware::class], "list.customersites")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersitesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/customersitesadd[/{siteId}]", [PermissionMiddleware::class], "add.customersites")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersitesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/customersitesview[/{siteId}]", [PermissionMiddleware::class], "view.customersites")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersitesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/customersitesedit[/{siteId}]", [PermissionMiddleware::class], "edit.customersites")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersitesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/customersitesdelete[/{siteId}]", [PermissionMiddleware::class], "delete.customersites")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomersitesDelete");
    }
}
