<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class LaundrytechUgrightsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugrightslist[/{keys:.*}]", [PermissionMiddleware::class], "list.laundrytech_ugrights")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgrightsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugrightsadd[/{keys:.*}]", [PermissionMiddleware::class], "add.laundrytech_ugrights")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgrightsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugrightsview[/{keys:.*}]", [PermissionMiddleware::class], "view.laundrytech_ugrights")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgrightsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugrightsedit[/{keys:.*}]", [PermissionMiddleware::class], "edit.laundrytech_ugrights")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgrightsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugrightsdelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.laundrytech_ugrights")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgrightsDelete");
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("laundrytech_ugrights")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 2) {
                $keyArgs = array_combine(["_TableName","GroupID"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
