<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CategoriesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/categorieslist[/{categoryid}]", [PermissionMiddleware::class], "list.categories")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CategoriesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/categoriesadd[/{categoryid}]", [PermissionMiddleware::class], "add.categories")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CategoriesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/categoriesview[/{categoryid}]", [PermissionMiddleware::class], "view.categories")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CategoriesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/categoriesedit[/{categoryid}]", [PermissionMiddleware::class], "edit.categories")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CategoriesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/categoriesdelete[/{categoryid}]", [PermissionMiddleware::class], "delete.categories")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CategoriesDelete");
    }
}
