<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class PricelistdetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pricelistdetailslist[/{priceListDetailId}]", [PermissionMiddleware::class], "list.pricelistdetails")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistdetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pricelistdetailsadd[/{priceListDetailId}]", [PermissionMiddleware::class], "add.pricelistdetails")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistdetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/pricelistdetailsview[/{priceListDetailId}]", [PermissionMiddleware::class], "view.pricelistdetails")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistdetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pricelistdetailsedit[/{priceListDetailId}]", [PermissionMiddleware::class], "edit.pricelistdetails")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistdetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pricelistdetailsdelete[/{priceListDetailId}]", [PermissionMiddleware::class], "delete.pricelistdetails")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistdetailsDelete");
    }
}
