<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Table class for customers
 */
class Customers extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $customerid;
    public $customername;
    public $ParentAgent;
    public $isAgent;
    public $priceListId;
    public $city;
    public $country;
    public $postcode;
    public $phone1;
    public $phone2;
    public $emailaddress;
    public $notes;
    public $customercode;
    public $address1;
    public $runid;
    public $contactperson;
    public $address2;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "customers";
        $this->TableName = 'customers';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "customers";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = null; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = null; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // customerid
        $this->customerid = new DbField(
            $this, // Table
            'x_customerid', // Variable name
            'customerid', // Name
            '`customerid`', // Expression
            '`customerid`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`customerid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->customerid->InputTextType = "text";
        $this->customerid->Raw = true;
        $this->customerid->IsAutoIncrement = true; // Autoincrement field
        $this->customerid->IsPrimaryKey = true; // Primary key field
        $this->customerid->IsForeignKey = true; // Foreign key field
        $this->customerid->Nullable = false; // NOT NULL field
        $this->customerid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->customerid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['customerid'] = &$this->customerid;

        // customername
        $this->customername = new DbField(
            $this, // Table
            'x_customername', // Variable name
            'customername', // Name
            '`customername`', // Expression
            '`customername`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`customername`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->customername->InputTextType = "text";
        $this->customername->Nullable = false; // NOT NULL field
        $this->customername->Required = true; // Required field
        $this->customername->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['customername'] = &$this->customername;

        // ParentAgent
        $this->ParentAgent = new DbField(
            $this, // Table
            'x_ParentAgent', // Variable name
            'ParentAgent', // Name
            '`ParentAgent`', // Expression
            '`ParentAgent`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ParentAgent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ParentAgent->InputTextType = "text";
        $this->ParentAgent->Raw = true;
        $this->ParentAgent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ParentAgent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ParentAgent'] = &$this->ParentAgent;

        // isAgent
        $this->isAgent = new DbField(
            $this, // Table
            'x_isAgent', // Variable name
            'isAgent', // Name
            '`isAgent`', // Expression
            '`isAgent`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`isAgent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->isAgent->InputTextType = "text";
        $this->isAgent->Raw = true;
        $this->isAgent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->isAgent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['isAgent'] = &$this->isAgent;

        // priceListId
        $this->priceListId = new DbField(
            $this, // Table
            'x_priceListId', // Variable name
            'priceListId', // Name
            '`priceListId`', // Expression
            '`priceListId`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`priceListId`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->priceListId->InputTextType = "text";
        $this->priceListId->Raw = true;
        $this->priceListId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->priceListId->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['priceListId'] = &$this->priceListId;

        // city
        $this->city = new DbField(
            $this, // Table
            'x_city', // Variable name
            'city', // Name
            '`city`', // Expression
            '`city`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`city`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->city->InputTextType = "text";
        $this->city->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['city'] = &$this->city;

        // country
        $this->country = new DbField(
            $this, // Table
            'x_country', // Variable name
            'country', // Name
            '`country`', // Expression
            '`country`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`country`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->country->InputTextType = "text";
        $this->country->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['country'] = &$this->country;

        // postcode
        $this->postcode = new DbField(
            $this, // Table
            'x_postcode', // Variable name
            'postcode', // Name
            '`postcode`', // Expression
            '`postcode`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`postcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->postcode->InputTextType = "text";
        $this->postcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['postcode'] = &$this->postcode;

        // phone1
        $this->phone1 = new DbField(
            $this, // Table
            'x_phone1', // Variable name
            'phone1', // Name
            '`phone1`', // Expression
            '`phone1`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`phone1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->phone1->InputTextType = "text";
        $this->phone1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['phone1'] = &$this->phone1;

        // phone2
        $this->phone2 = new DbField(
            $this, // Table
            'x_phone2', // Variable name
            'phone2', // Name
            '`phone2`', // Expression
            '`phone2`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`phone2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->phone2->InputTextType = "text";
        $this->phone2->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['phone2'] = &$this->phone2;

        // emailaddress
        $this->emailaddress = new DbField(
            $this, // Table
            'x_emailaddress', // Variable name
            'emailaddress', // Name
            '`emailaddress`', // Expression
            '`emailaddress`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emailaddress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emailaddress->InputTextType = "text";
        $this->emailaddress->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['emailaddress'] = &$this->emailaddress;

        // notes
        $this->notes = new DbField(
            $this, // Table
            'x_notes', // Variable name
            'notes', // Name
            '`notes`', // Expression
            '`notes`', // Basic search expression
            204, // Type
            65535, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`notes`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->notes->InputTextType = "text";
        $this->notes->Raw = true;
        $this->notes->Sortable = false; // Allow sort
        $this->notes->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['notes'] = &$this->notes;

        // customercode
        $this->customercode = new DbField(
            $this, // Table
            'x_customercode', // Variable name
            'customercode', // Name
            '`customercode`', // Expression
            '`customercode`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`customercode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->customercode->InputTextType = "text";
        $this->customercode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['customercode'] = &$this->customercode;

        // address1
        $this->address1 = new DbField(
            $this, // Table
            'x_address1', // Variable name
            'address1', // Name
            '`address1`', // Expression
            '`address1`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`address1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->address1->InputTextType = "text";
        $this->address1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['address1'] = &$this->address1;

        // runid
        $this->runid = new DbField(
            $this, // Table
            'x_runid', // Variable name
            'runid', // Name
            '`runid`', // Expression
            '`runid`', // Basic search expression
            3, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`runid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->runid->InputTextType = "text";
        $this->runid->Raw = true;
        $this->runid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->runid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['runid'] = &$this->runid;

        // contactperson
        $this->contactperson = new DbField(
            $this, // Table
            'x_contactperson', // Variable name
            'contactperson', // Name
            '`contactperson`', // Expression
            '`contactperson`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`contactperson`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->contactperson->InputTextType = "text";
        $this->contactperson->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['contactperson'] = &$this->contactperson;

        // address2
        $this->address2 = new DbField(
            $this, // Table
            'x_address2', // Variable name
            'address2', // Name
            '`address2`', // Expression
            '`address2`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`address2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->address2->InputTextType = "text";
        $this->address2->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['address2'] = &$this->address2;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "customerhasarticles") {
            $detailUrl = Container("customerhasarticles")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_customerid", $this->customerid->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "customerslist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "customers";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->customerid->setDbValue($conn->lastInsertId());
            $rs['customerid'] = $this->customerid->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['customerid']) && !EmptyValue($this->customerid->CurrentValue)) {
                $rs['customerid'] = $this->customerid->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('customerid', $rs)) {
                AddFilter($where, QuotedName('customerid', $this->Dbid) . '=' . QuotedValue($rs['customerid'], $this->customerid->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->customerid->DbValue = $row['customerid'];
        $this->customername->DbValue = $row['customername'];
        $this->ParentAgent->DbValue = $row['ParentAgent'];
        $this->isAgent->DbValue = $row['isAgent'];
        $this->priceListId->DbValue = $row['priceListId'];
        $this->city->DbValue = $row['city'];
        $this->country->DbValue = $row['country'];
        $this->postcode->DbValue = $row['postcode'];
        $this->phone1->DbValue = $row['phone1'];
        $this->phone2->DbValue = $row['phone2'];
        $this->emailaddress->DbValue = $row['emailaddress'];
        $this->notes->Upload->DbValue = $row['notes'];
        $this->customercode->DbValue = $row['customercode'];
        $this->address1->DbValue = $row['address1'];
        $this->runid->DbValue = $row['runid'];
        $this->contactperson->DbValue = $row['contactperson'];
        $this->address2->DbValue = $row['address2'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`customerid` = @customerid@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->customerid->CurrentValue : $this->customerid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->customerid->CurrentValue = $keys[0];
            } else {
                $this->customerid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('customerid', $row) ? $row['customerid'] : null;
        } else {
            $val = !EmptyValue($this->customerid->OldValue) && !$current ? $this->customerid->OldValue : $this->customerid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@customerid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("customerslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "customersview" => $Language->phrase("View"),
            "customersedit" => $Language->phrase("Edit"),
            "customersadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "customerslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "CustomersView",
            Config("API_ADD_ACTION") => "CustomersAdd",
            Config("API_EDIT_ACTION") => "CustomersEdit",
            Config("API_DELETE_ACTION") => "CustomersDelete",
            Config("API_LIST_ACTION") => "CustomersList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "customerslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("customersview", $parm);
        } else {
            $url = $this->keyUrl("customersview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "customersadd?" . $parm;
        } else {
            $url = "customersadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("customersedit", $parm);
        } else {
            $url = $this->keyUrl("customersedit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("customerslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("customersadd", $parm);
        } else {
            $url = $this->keyUrl("customersadd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("customerslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("customersdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"customerid\":" . VarToJson($this->customerid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->customerid->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->customerid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("customerid") ?? Route("customerid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->customerid->CurrentValue = $key;
            } else {
                $this->customerid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->customerid->setDbValue($row['customerid']);
        $this->customername->setDbValue($row['customername']);
        $this->ParentAgent->setDbValue($row['ParentAgent']);
        $this->isAgent->setDbValue($row['isAgent']);
        $this->priceListId->setDbValue($row['priceListId']);
        $this->city->setDbValue($row['city']);
        $this->country->setDbValue($row['country']);
        $this->postcode->setDbValue($row['postcode']);
        $this->phone1->setDbValue($row['phone1']);
        $this->phone2->setDbValue($row['phone2']);
        $this->emailaddress->setDbValue($row['emailaddress']);
        $this->notes->Upload->DbValue = $row['notes'];
        $this->customercode->setDbValue($row['customercode']);
        $this->address1->setDbValue($row['address1']);
        $this->runid->setDbValue($row['runid']);
        $this->contactperson->setDbValue($row['contactperson']);
        $this->address2->setDbValue($row['address2']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "CustomersList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // customerid

        // customername

        // ParentAgent

        // isAgent

        // priceListId

        // city

        // country

        // postcode

        // phone1

        // phone2

        // emailaddress

        // notes

        // customercode

        // address1

        // runid

        // contactperson

        // address2

        // customerid
        $this->customerid->ViewValue = $this->customerid->CurrentValue;

        // customername
        $this->customername->ViewValue = $this->customername->CurrentValue;

        // ParentAgent
        $this->ParentAgent->ViewValue = $this->ParentAgent->CurrentValue;
        $this->ParentAgent->ViewValue = FormatNumber($this->ParentAgent->ViewValue, $this->ParentAgent->formatPattern());

        // isAgent
        $this->isAgent->ViewValue = $this->isAgent->CurrentValue;
        $this->isAgent->ViewValue = FormatNumber($this->isAgent->ViewValue, $this->isAgent->formatPattern());

        // priceListId
        $this->priceListId->ViewValue = $this->priceListId->CurrentValue;
        $this->priceListId->ViewValue = FormatNumber($this->priceListId->ViewValue, $this->priceListId->formatPattern());

        // city
        $this->city->ViewValue = $this->city->CurrentValue;

        // country
        $this->country->ViewValue = $this->country->CurrentValue;

        // postcode
        $this->postcode->ViewValue = $this->postcode->CurrentValue;

        // phone1
        $this->phone1->ViewValue = $this->phone1->CurrentValue;

        // phone2
        $this->phone2->ViewValue = $this->phone2->CurrentValue;

        // emailaddress
        $this->emailaddress->ViewValue = $this->emailaddress->CurrentValue;

        // notes
        if (!EmptyValue($this->notes->Upload->DbValue)) {
            $this->notes->ViewValue = $this->customerid->CurrentValue;
            $this->notes->IsBlobImage = IsImageFile(ContentExtension($this->notes->Upload->DbValue));
        } else {
            $this->notes->ViewValue = "";
        }

        // customercode
        $this->customercode->ViewValue = $this->customercode->CurrentValue;

        // address1
        $this->address1->ViewValue = $this->address1->CurrentValue;

        // runid
        $this->runid->ViewValue = $this->runid->CurrentValue;
        $this->runid->ViewValue = FormatNumber($this->runid->ViewValue, $this->runid->formatPattern());

        // contactperson
        $this->contactperson->ViewValue = $this->contactperson->CurrentValue;

        // address2
        $this->address2->ViewValue = $this->address2->CurrentValue;

        // customerid
        $this->customerid->HrefValue = "";
        $this->customerid->TooltipValue = "";

        // customername
        $this->customername->HrefValue = "";
        $this->customername->TooltipValue = "";

        // ParentAgent
        $this->ParentAgent->HrefValue = "";
        $this->ParentAgent->TooltipValue = "";

        // isAgent
        $this->isAgent->HrefValue = "";
        $this->isAgent->TooltipValue = "";

        // priceListId
        $this->priceListId->HrefValue = "";
        $this->priceListId->TooltipValue = "";

        // city
        $this->city->HrefValue = "";
        $this->city->TooltipValue = "";

        // country
        $this->country->HrefValue = "";
        $this->country->TooltipValue = "";

        // postcode
        $this->postcode->HrefValue = "";
        $this->postcode->TooltipValue = "";

        // phone1
        $this->phone1->HrefValue = "";
        $this->phone1->TooltipValue = "";

        // phone2
        $this->phone2->HrefValue = "";
        $this->phone2->TooltipValue = "";

        // emailaddress
        $this->emailaddress->HrefValue = "";
        $this->emailaddress->TooltipValue = "";

        // notes
        if (!empty($this->notes->Upload->DbValue)) {
            $this->notes->HrefValue = GetFileUploadUrl($this->notes, $this->customerid->CurrentValue);
            $this->notes->LinkAttrs["target"] = "";
            if ($this->notes->IsBlobImage && empty($this->notes->LinkAttrs["target"])) {
                $this->notes->LinkAttrs["target"] = "_blank";
            }
            if ($this->isExport()) {
                $this->notes->HrefValue = FullUrl($this->notes->HrefValue, "href");
            }
        } else {
            $this->notes->HrefValue = "";
        }
        $this->notes->ExportHrefValue = GetFileUploadUrl($this->notes, $this->customerid->CurrentValue);
        $this->notes->TooltipValue = "";

        // customercode
        $this->customercode->HrefValue = "";
        $this->customercode->TooltipValue = "";

        // address1
        $this->address1->HrefValue = "";
        $this->address1->TooltipValue = "";

        // runid
        $this->runid->HrefValue = "";
        $this->runid->TooltipValue = "";

        // contactperson
        $this->contactperson->HrefValue = "";
        $this->contactperson->TooltipValue = "";

        // address2
        $this->address2->HrefValue = "";
        $this->address2->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // customerid
        $this->customerid->setupEditAttributes();
        $this->customerid->EditValue = $this->customerid->CurrentValue;

        // customername
        $this->customername->setupEditAttributes();
        if (!$this->customername->Raw) {
            $this->customername->CurrentValue = HtmlDecode($this->customername->CurrentValue);
        }
        $this->customername->EditValue = $this->customername->CurrentValue;
        $this->customername->PlaceHolder = RemoveHtml($this->customername->caption());

        // ParentAgent
        $this->ParentAgent->setupEditAttributes();
        $this->ParentAgent->EditValue = $this->ParentAgent->CurrentValue;
        $this->ParentAgent->PlaceHolder = RemoveHtml($this->ParentAgent->caption());
        if (strval($this->ParentAgent->EditValue) != "" && is_numeric($this->ParentAgent->EditValue)) {
            $this->ParentAgent->EditValue = FormatNumber($this->ParentAgent->EditValue, null);
        }

        // isAgent
        $this->isAgent->setupEditAttributes();
        $this->isAgent->EditValue = $this->isAgent->CurrentValue;
        $this->isAgent->PlaceHolder = RemoveHtml($this->isAgent->caption());
        if (strval($this->isAgent->EditValue) != "" && is_numeric($this->isAgent->EditValue)) {
            $this->isAgent->EditValue = FormatNumber($this->isAgent->EditValue, null);
        }

        // priceListId
        $this->priceListId->setupEditAttributes();
        $this->priceListId->EditValue = $this->priceListId->CurrentValue;
        $this->priceListId->PlaceHolder = RemoveHtml($this->priceListId->caption());
        if (strval($this->priceListId->EditValue) != "" && is_numeric($this->priceListId->EditValue)) {
            $this->priceListId->EditValue = FormatNumber($this->priceListId->EditValue, null);
        }

        // city
        $this->city->setupEditAttributes();
        if (!$this->city->Raw) {
            $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
        }
        $this->city->EditValue = $this->city->CurrentValue;
        $this->city->PlaceHolder = RemoveHtml($this->city->caption());

        // country
        $this->country->setupEditAttributes();
        if (!$this->country->Raw) {
            $this->country->CurrentValue = HtmlDecode($this->country->CurrentValue);
        }
        $this->country->EditValue = $this->country->CurrentValue;
        $this->country->PlaceHolder = RemoveHtml($this->country->caption());

        // postcode
        $this->postcode->setupEditAttributes();
        if (!$this->postcode->Raw) {
            $this->postcode->CurrentValue = HtmlDecode($this->postcode->CurrentValue);
        }
        $this->postcode->EditValue = $this->postcode->CurrentValue;
        $this->postcode->PlaceHolder = RemoveHtml($this->postcode->caption());

        // phone1
        $this->phone1->setupEditAttributes();
        if (!$this->phone1->Raw) {
            $this->phone1->CurrentValue = HtmlDecode($this->phone1->CurrentValue);
        }
        $this->phone1->EditValue = $this->phone1->CurrentValue;
        $this->phone1->PlaceHolder = RemoveHtml($this->phone1->caption());

        // phone2
        $this->phone2->setupEditAttributes();
        if (!$this->phone2->Raw) {
            $this->phone2->CurrentValue = HtmlDecode($this->phone2->CurrentValue);
        }
        $this->phone2->EditValue = $this->phone2->CurrentValue;
        $this->phone2->PlaceHolder = RemoveHtml($this->phone2->caption());

        // emailaddress
        $this->emailaddress->setupEditAttributes();
        if (!$this->emailaddress->Raw) {
            $this->emailaddress->CurrentValue = HtmlDecode($this->emailaddress->CurrentValue);
        }
        $this->emailaddress->EditValue = $this->emailaddress->CurrentValue;
        $this->emailaddress->PlaceHolder = RemoveHtml($this->emailaddress->caption());

        // notes
        $this->notes->setupEditAttributes();
        if (!EmptyValue($this->notes->Upload->DbValue)) {
            $this->notes->EditValue = $this->customerid->CurrentValue;
            $this->notes->IsBlobImage = IsImageFile(ContentExtension($this->notes->Upload->DbValue));
        } else {
            $this->notes->EditValue = "";
        }

        // customercode
        $this->customercode->setupEditAttributes();
        if (!$this->customercode->Raw) {
            $this->customercode->CurrentValue = HtmlDecode($this->customercode->CurrentValue);
        }
        $this->customercode->EditValue = $this->customercode->CurrentValue;
        $this->customercode->PlaceHolder = RemoveHtml($this->customercode->caption());

        // address1
        $this->address1->setupEditAttributes();
        if (!$this->address1->Raw) {
            $this->address1->CurrentValue = HtmlDecode($this->address1->CurrentValue);
        }
        $this->address1->EditValue = $this->address1->CurrentValue;
        $this->address1->PlaceHolder = RemoveHtml($this->address1->caption());

        // runid
        $this->runid->setupEditAttributes();
        $this->runid->EditValue = $this->runid->CurrentValue;
        $this->runid->PlaceHolder = RemoveHtml($this->runid->caption());
        if (strval($this->runid->EditValue) != "" && is_numeric($this->runid->EditValue)) {
            $this->runid->EditValue = FormatNumber($this->runid->EditValue, null);
        }

        // contactperson
        $this->contactperson->setupEditAttributes();
        if (!$this->contactperson->Raw) {
            $this->contactperson->CurrentValue = HtmlDecode($this->contactperson->CurrentValue);
        }
        $this->contactperson->EditValue = $this->contactperson->CurrentValue;
        $this->contactperson->PlaceHolder = RemoveHtml($this->contactperson->caption());

        // address2
        $this->address2->setupEditAttributes();
        if (!$this->address2->Raw) {
            $this->address2->CurrentValue = HtmlDecode($this->address2->CurrentValue);
        }
        $this->address2->EditValue = $this->address2->CurrentValue;
        $this->address2->PlaceHolder = RemoveHtml($this->address2->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->customerid);
                    $doc->exportCaption($this->customername);
                    $doc->exportCaption($this->ParentAgent);
                    $doc->exportCaption($this->isAgent);
                    $doc->exportCaption($this->priceListId);
                    $doc->exportCaption($this->city);
                    $doc->exportCaption($this->country);
                    $doc->exportCaption($this->postcode);
                    $doc->exportCaption($this->phone1);
                    $doc->exportCaption($this->phone2);
                    $doc->exportCaption($this->emailaddress);
                    $doc->exportCaption($this->notes);
                    $doc->exportCaption($this->customercode);
                    $doc->exportCaption($this->address1);
                    $doc->exportCaption($this->runid);
                    $doc->exportCaption($this->contactperson);
                    $doc->exportCaption($this->address2);
                } else {
                    $doc->exportCaption($this->customerid);
                    $doc->exportCaption($this->customername);
                    $doc->exportCaption($this->ParentAgent);
                    $doc->exportCaption($this->isAgent);
                    $doc->exportCaption($this->priceListId);
                    $doc->exportCaption($this->city);
                    $doc->exportCaption($this->country);
                    $doc->exportCaption($this->postcode);
                    $doc->exportCaption($this->phone1);
                    $doc->exportCaption($this->phone2);
                    $doc->exportCaption($this->emailaddress);
                    $doc->exportCaption($this->customercode);
                    $doc->exportCaption($this->address1);
                    $doc->exportCaption($this->runid);
                    $doc->exportCaption($this->contactperson);
                    $doc->exportCaption($this->address2);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->customerid);
                        $doc->exportField($this->customername);
                        $doc->exportField($this->ParentAgent);
                        $doc->exportField($this->isAgent);
                        $doc->exportField($this->priceListId);
                        $doc->exportField($this->city);
                        $doc->exportField($this->country);
                        $doc->exportField($this->postcode);
                        $doc->exportField($this->phone1);
                        $doc->exportField($this->phone2);
                        $doc->exportField($this->emailaddress);
                        $doc->exportField($this->notes);
                        $doc->exportField($this->customercode);
                        $doc->exportField($this->address1);
                        $doc->exportField($this->runid);
                        $doc->exportField($this->contactperson);
                        $doc->exportField($this->address2);
                    } else {
                        $doc->exportField($this->customerid);
                        $doc->exportField($this->customername);
                        $doc->exportField($this->ParentAgent);
                        $doc->exportField($this->isAgent);
                        $doc->exportField($this->priceListId);
                        $doc->exportField($this->city);
                        $doc->exportField($this->country);
                        $doc->exportField($this->postcode);
                        $doc->exportField($this->phone1);
                        $doc->exportField($this->phone2);
                        $doc->exportField($this->emailaddress);
                        $doc->exportField($this->customercode);
                        $doc->exportField($this->address1);
                        $doc->exportField($this->runid);
                        $doc->exportField($this->contactperson);
                        $doc->exportField($this->address2);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'notes') {
            $fldName = "notes";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->customerid->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
