<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "customers" table
 */
#[Entity]
#[Table(name: "customers")]
class Customer extends AbstractEntity
{
    public static array $propertyNames = [
        'customerid' => 'customerid',
        'customername' => 'customername',
        'ParentAgent' => 'parentAgent',
        'isAgent' => 'isAgent',
        'priceListId' => 'priceListId',
        'city' => 'city',
        'country' => 'country',
        'postcode' => 'postcode',
        'phone1' => 'phone1',
        'phone2' => 'phone2',
        'emailaddress' => 'emailaddress',
        'notes' => 'notes',
        'customercode' => 'customercode',
        'address1' => 'address1',
        'runid' => 'runid',
        'contactperson' => 'contactperson',
        'address2' => 'address2',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $customerid;

    #[Column(type: "string")]
    private string $customername;

    #[Column(name: "ParentAgent", type: "integer", nullable: true)]
    private ?int $parentAgent;

    #[Column(type: "integer", nullable: true)]
    private ?int $isAgent;

    #[Column(type: "integer", nullable: true)]
    private ?int $priceListId;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    #[Column(type: "string", nullable: true)]
    private ?string $country;

    #[Column(type: "string", nullable: true)]
    private ?string $postcode;

    #[Column(type: "string", nullable: true)]
    private ?string $phone1;

    #[Column(type: "string", nullable: true)]
    private ?string $phone2;

    #[Column(type: "string", nullable: true)]
    private ?string $emailaddress;

    #[Column(type: "blob", nullable: true)]
    private mixed $notes;

    #[Column(type: "string", nullable: true)]
    private ?string $customercode;

    #[Column(type: "string", nullable: true)]
    private ?string $address1;

    #[Column(type: "integer", nullable: true)]
    private ?int $runid;

    #[Column(type: "string", nullable: true)]
    private ?string $contactperson;

    #[Column(type: "string", nullable: true)]
    private ?string $address2;

    public function getCustomerid(): int
    {
        return $this->customerid;
    }

    public function setCustomerid(int $value): static
    {
        $this->customerid = $value;
        return $this;
    }

    public function getCustomername(): string
    {
        return HtmlDecode($this->customername);
    }

    public function setCustomername(string $value): static
    {
        $this->customername = RemoveXss($value);
        return $this;
    }

    public function getParentAgent(): ?int
    {
        return $this->parentAgent;
    }

    public function setParentAgent(?int $value): static
    {
        $this->parentAgent = $value;
        return $this;
    }

    public function getIsAgent(): ?int
    {
        return $this->isAgent;
    }

    public function setIsAgent(?int $value): static
    {
        $this->isAgent = $value;
        return $this;
    }

    public function getPriceListId(): ?int
    {
        return $this->priceListId;
    }

    public function setPriceListId(?int $value): static
    {
        $this->priceListId = $value;
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?string
    {
        return HtmlDecode($this->country);
    }

    public function setCountry(?string $value): static
    {
        $this->country = RemoveXss($value);
        return $this;
    }

    public function getPostcode(): ?string
    {
        return HtmlDecode($this->postcode);
    }

    public function setPostcode(?string $value): static
    {
        $this->postcode = RemoveXss($value);
        return $this;
    }

    public function getPhone1(): ?string
    {
        return HtmlDecode($this->phone1);
    }

    public function setPhone1(?string $value): static
    {
        $this->phone1 = RemoveXss($value);
        return $this;
    }

    public function getPhone2(): ?string
    {
        return HtmlDecode($this->phone2);
    }

    public function setPhone2(?string $value): static
    {
        $this->phone2 = RemoveXss($value);
        return $this;
    }

    public function getEmailaddress(): ?string
    {
        return HtmlDecode($this->emailaddress);
    }

    public function setEmailaddress(?string $value): static
    {
        $this->emailaddress = RemoveXss($value);
        return $this;
    }

    public function getNotes(): mixed
    {
        return $this->notes;
    }

    public function setNotes(mixed $value): static
    {
        $this->notes = $value;
        return $this;
    }

    public function getCustomercode(): ?string
    {
        return HtmlDecode($this->customercode);
    }

    public function setCustomercode(?string $value): static
    {
        $this->customercode = RemoveXss($value);
        return $this;
    }

    public function getAddress1(): ?string
    {
        return HtmlDecode($this->address1);
    }

    public function setAddress1(?string $value): static
    {
        $this->address1 = RemoveXss($value);
        return $this;
    }

    public function getRunid(): ?int
    {
        return $this->runid;
    }

    public function setRunid(?int $value): static
    {
        $this->runid = $value;
        return $this;
    }

    public function getContactperson(): ?string
    {
        return HtmlDecode($this->contactperson);
    }

    public function setContactperson(?string $value): static
    {
        $this->contactperson = RemoveXss($value);
        return $this;
    }

    public function getAddress2(): ?string
    {
        return HtmlDecode($this->address2);
    }

    public function setAddress2(?string $value): static
    {
        $this->address2 = RemoveXss($value);
        return $this;
    }
}
