<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "customerpackingprefs" table
 */
#[Entity]
#[Table(name: "customerpackingprefs")]
class Customerpackingpref extends AbstractEntity
{
    public static array $propertyNames = [
        'prefID' => 'prefId',
        'prefName' => 'prefName',
    ];

    #[Id]
    #[Column(name: "prefID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $prefId;

    #[Column(type: "string")]
    private string $prefName;

    public function getPrefId(): int
    {
        return $this->prefId;
    }

    public function setPrefId(int $value): static
    {
        $this->prefId = $value;
        return $this;
    }

    public function getPrefName(): string
    {
        return HtmlDecode($this->prefName);
    }

    public function setPrefName(string $value): static
    {
        $this->prefName = RemoveXss($value);
        return $this;
    }
}
