<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "packagetypes" table
 */
#[Entity]
#[Table(name: "packagetypes")]
class Packagetype extends AbstractEntity
{
    public static array $propertyNames = [
        'packageTypeId' => 'packageTypeId',
        'packageTypeName' => 'packageTypeName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $packageTypeId;

    #[Column(type: "string")]
    private string $packageTypeName;

    public function getPackageTypeId(): int
    {
        return $this->packageTypeId;
    }

    public function setPackageTypeId(int $value): static
    {
        $this->packageTypeId = $value;
        return $this;
    }

    public function getPackageTypeName(): string
    {
        return HtmlDecode($this->packageTypeName);
    }

    public function setPackageTypeName(string $value): static
    {
        $this->packageTypeName = RemoveXss($value);
        return $this;
    }
}
