<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "stations" table
 */
#[Entity]
#[Table(name: "stations")]
class Station extends AbstractEntity
{
    public static array $propertyNames = [
        'stationId' => 'stationId',
        'stageId' => 'stageId',
        'stationName' => 'stationName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $stationId;

    #[Column(type: "integer")]
    private int $stageId;

    #[Column(type: "string")]
    private string $stationName;

    public function getStationId(): int
    {
        return $this->stationId;
    }

    public function setStationId(int $value): static
    {
        $this->stationId = $value;
        return $this;
    }

    public function getStageId(): int
    {
        return $this->stageId;
    }

    public function setStageId(int $value): static
    {
        $this->stageId = $value;
        return $this;
    }

    public function getStationName(): string
    {
        return HtmlDecode($this->stationName);
    }

    public function setStationName(string $value): static
    {
        $this->stationName = RemoveXss($value);
        return $this;
    }
}
