<?php

namespace PHPMaker2024\laundrytech;

// Page object
$RunsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { runs: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var frunsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("frunsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["runName", [fields.runName.visible && fields.runName.required ? ew.Validators.required(fields.runName.caption) : null], fields.runName.isInvalid],
            ["runDays", [fields.runDays.visible && fields.runDays.required ? ew.Validators.required(fields.runDays.caption) : null], fields.runDays.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frunsadd" id="frunsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="runs">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->runName->Visible) { // runName ?>
    <div id="r_runName"<?= $Page->runName->rowAttributes() ?>>
        <label id="elh_runs_runName" for="x_runName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->runName->caption() ?><?= $Page->runName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->runName->cellAttributes() ?>>
<span id="el_runs_runName">
<input type="<?= $Page->runName->getInputTextType() ?>" name="x_runName" id="x_runName" data-table="runs" data-field="x_runName" value="<?= $Page->runName->EditValue ?>" size="30" maxlength="25" placeholder="<?= HtmlEncode($Page->runName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->runName->formatPattern()) ?>"<?= $Page->runName->editAttributes() ?> aria-describedby="x_runName_help">
<?= $Page->runName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->runName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->runDays->Visible) { // runDays ?>
    <div id="r_runDays"<?= $Page->runDays->rowAttributes() ?>>
        <label id="elh_runs_runDays" for="x_runDays" class="<?= $Page->LeftColumnClass ?>"><?= $Page->runDays->caption() ?><?= $Page->runDays->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->runDays->cellAttributes() ?>>
<span id="el_runs_runDays">
<input type="<?= $Page->runDays->getInputTextType() ?>" name="x_runDays" id="x_runDays" data-table="runs" data-field="x_runDays" value="<?= $Page->runDays->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->runDays->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->runDays->formatPattern()) ?>"<?= $Page->runDays->editAttributes() ?> aria-describedby="x_runDays_help">
<?= $Page->runDays->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->runDays->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frunsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frunsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("runs");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
