<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CagesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/cageslist[/{cageId}]", [PermissionMiddleware::class], "list.cages")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CagesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/cagesadd[/{cageId}]", [PermissionMiddleware::class], "add.cages")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CagesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/cagesview[/{cageId}]", [PermissionMiddleware::class], "view.cages")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CagesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/cagesedit[/{cageId}]", [PermissionMiddleware::class], "edit.cages")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CagesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/cagesdelete[/{cageId}]", [PermissionMiddleware::class], "delete.cages")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CagesDelete");
    }
}
