<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class PricelistsdetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pricelistsdetailslist[/{priceListDetailId}]", [PermissionMiddleware::class], "list.pricelistsdetails")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistsdetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pricelistsdetailsadd[/{priceListDetailId}]", [PermissionMiddleware::class], "add.pricelistsdetails")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistsdetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/pricelistsdetailsview[/{priceListDetailId}]", [PermissionMiddleware::class], "view.pricelistsdetails")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistsdetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pricelistsdetailsedit[/{priceListDetailId}]", [PermissionMiddleware::class], "edit.pricelistsdetails")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistsdetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pricelistsdetailsdelete[/{priceListDetailId}]", [PermissionMiddleware::class], "delete.pricelistsdetails")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistsdetailsDelete");
    }
}
