<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class OrdersAdd extends Orders
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OrdersAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ordersadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->orderid->Visible = false;
        $this->customerid->setVisibility();
        $this->bookingdatetime->setVisibility();
        $this->dueby->setVisibility();
        $this->ordertype->setVisibility();
        $this->invoiced->setVisibility();
        $this->paid->setVisibility();
        $this->ordervalue->setVisibility();
        $this->jobType->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'orders';
        $this->TableName = 'orders';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (orders)
        if (!isset($GLOBALS["orders"]) || $GLOBALS["orders"]::class == PROJECT_NAMESPACE . "orders") {
            $GLOBALS["orders"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'orders');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "ordersview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['orderid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->orderid->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->customerid);
        $this->setupLookupOptions($this->ordertype);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("orderid") ?? Route("orderid")) !== null) {
                $this->orderid->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("orderslist"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "orderslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "ordersview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "orderslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "orderslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'customerid' first before field var 'x_customerid'
        $val = $CurrentForm->hasValue("customerid") ? $CurrentForm->getValue("customerid") : $CurrentForm->getValue("x_customerid");
        if (!$this->customerid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->customerid->Visible = false; // Disable update for API request
            } else {
                $this->customerid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'bookingdatetime' first before field var 'x_bookingdatetime'
        $val = $CurrentForm->hasValue("bookingdatetime") ? $CurrentForm->getValue("bookingdatetime") : $CurrentForm->getValue("x_bookingdatetime");
        if (!$this->bookingdatetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bookingdatetime->Visible = false; // Disable update for API request
            } else {
                $this->bookingdatetime->setFormValue($val, true, $validate);
            }
            $this->bookingdatetime->CurrentValue = UnFormatDateTime($this->bookingdatetime->CurrentValue, $this->bookingdatetime->formatPattern());
        }

        // Check field name 'dueby' first before field var 'x_dueby'
        $val = $CurrentForm->hasValue("dueby") ? $CurrentForm->getValue("dueby") : $CurrentForm->getValue("x_dueby");
        if (!$this->dueby->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dueby->Visible = false; // Disable update for API request
            } else {
                $this->dueby->setFormValue($val, true, $validate);
            }
            $this->dueby->CurrentValue = UnFormatDateTime($this->dueby->CurrentValue, $this->dueby->formatPattern());
        }

        // Check field name 'ordertype' first before field var 'x_ordertype'
        $val = $CurrentForm->hasValue("ordertype") ? $CurrentForm->getValue("ordertype") : $CurrentForm->getValue("x_ordertype");
        if (!$this->ordertype->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ordertype->Visible = false; // Disable update for API request
            } else {
                $this->ordertype->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'invoiced' first before field var 'x_invoiced'
        $val = $CurrentForm->hasValue("invoiced") ? $CurrentForm->getValue("invoiced") : $CurrentForm->getValue("x_invoiced");
        if (!$this->invoiced->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoiced->Visible = false; // Disable update for API request
            } else {
                $this->invoiced->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'paid' first before field var 'x_paid'
        $val = $CurrentForm->hasValue("paid") ? $CurrentForm->getValue("paid") : $CurrentForm->getValue("x_paid");
        if (!$this->paid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->paid->Visible = false; // Disable update for API request
            } else {
                $this->paid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ordervalue' first before field var 'x_ordervalue'
        $val = $CurrentForm->hasValue("ordervalue") ? $CurrentForm->getValue("ordervalue") : $CurrentForm->getValue("x_ordervalue");
        if (!$this->ordervalue->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ordervalue->Visible = false; // Disable update for API request
            } else {
                $this->ordervalue->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jobType' first before field var 'x_jobType'
        $val = $CurrentForm->hasValue("jobType") ? $CurrentForm->getValue("jobType") : $CurrentForm->getValue("x_jobType");
        if (!$this->jobType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jobType->Visible = false; // Disable update for API request
            } else {
                $this->jobType->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'orderid' first before field var 'x_orderid'
        $val = $CurrentForm->hasValue("orderid") ? $CurrentForm->getValue("orderid") : $CurrentForm->getValue("x_orderid");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->customerid->CurrentValue = $this->customerid->FormValue;
        $this->bookingdatetime->CurrentValue = $this->bookingdatetime->FormValue;
        $this->bookingdatetime->CurrentValue = UnFormatDateTime($this->bookingdatetime->CurrentValue, $this->bookingdatetime->formatPattern());
        $this->dueby->CurrentValue = $this->dueby->FormValue;
        $this->dueby->CurrentValue = UnFormatDateTime($this->dueby->CurrentValue, $this->dueby->formatPattern());
        $this->ordertype->CurrentValue = $this->ordertype->FormValue;
        $this->invoiced->CurrentValue = $this->invoiced->FormValue;
        $this->paid->CurrentValue = $this->paid->FormValue;
        $this->ordervalue->CurrentValue = $this->ordervalue->FormValue;
        $this->jobType->CurrentValue = $this->jobType->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->orderid->setDbValue($row['orderid']);
        $this->customerid->setDbValue($row['customerid']);
        $this->bookingdatetime->setDbValue($row['bookingdatetime']);
        $this->dueby->setDbValue($row['dueby']);
        $this->ordertype->setDbValue($row['ordertype']);
        $this->invoiced->setDbValue($row['invoiced']);
        $this->paid->setDbValue($row['paid']);
        $this->ordervalue->setDbValue($row['ordervalue']);
        $this->jobType->setDbValue($row['jobType']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['orderid'] = $this->orderid->DefaultValue;
        $row['customerid'] = $this->customerid->DefaultValue;
        $row['bookingdatetime'] = $this->bookingdatetime->DefaultValue;
        $row['dueby'] = $this->dueby->DefaultValue;
        $row['ordertype'] = $this->ordertype->DefaultValue;
        $row['invoiced'] = $this->invoiced->DefaultValue;
        $row['paid'] = $this->paid->DefaultValue;
        $row['ordervalue'] = $this->ordervalue->DefaultValue;
        $row['jobType'] = $this->jobType->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // orderid
        $this->orderid->RowCssClass = "row";

        // customerid
        $this->customerid->RowCssClass = "row";

        // bookingdatetime
        $this->bookingdatetime->RowCssClass = "row";

        // dueby
        $this->dueby->RowCssClass = "row";

        // ordertype
        $this->ordertype->RowCssClass = "row";

        // invoiced
        $this->invoiced->RowCssClass = "row";

        // paid
        $this->paid->RowCssClass = "row";

        // ordervalue
        $this->ordervalue->RowCssClass = "row";

        // jobType
        $this->jobType->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // orderid
            $this->orderid->ViewValue = $this->orderid->CurrentValue;

            // customerid
            $this->customerid->ViewValue = $this->customerid->CurrentValue;
            $curVal = strval($this->customerid->CurrentValue);
            if ($curVal != "") {
                $this->customerid->ViewValue = $this->customerid->lookupCacheOption($curVal);
                if ($this->customerid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->customerid->Lookup->getTable()->Fields["customerid"]->searchExpression(), "=", $curVal, $this->customerid->Lookup->getTable()->Fields["customerid"]->searchDataType(), "");
                    $sqlWrk = $this->customerid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->customerid->Lookup->renderViewRow($rswrk[0]);
                        $this->customerid->ViewValue = $this->customerid->displayValue($arwrk);
                    } else {
                        $this->customerid->ViewValue = FormatNumber($this->customerid->CurrentValue, $this->customerid->formatPattern());
                    }
                }
            } else {
                $this->customerid->ViewValue = null;
            }

            // bookingdatetime
            $this->bookingdatetime->ViewValue = $this->bookingdatetime->CurrentValue;
            $this->bookingdatetime->ViewValue = FormatDateTime($this->bookingdatetime->ViewValue, $this->bookingdatetime->formatPattern());

            // dueby
            $this->dueby->ViewValue = $this->dueby->CurrentValue;
            $this->dueby->ViewValue = FormatDateTime($this->dueby->ViewValue, $this->dueby->formatPattern());

            // ordertype
            $this->ordertype->ViewValue = $this->ordertype->CurrentValue;
            $curVal = strval($this->ordertype->CurrentValue);
            if ($curVal != "") {
                $this->ordertype->ViewValue = $this->ordertype->lookupCacheOption($curVal);
                if ($this->ordertype->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ordertype->Lookup->getTable()->Fields["ordertypeid"]->searchExpression(), "=", $curVal, $this->ordertype->Lookup->getTable()->Fields["ordertypeid"]->searchDataType(), "");
                    $sqlWrk = $this->ordertype->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ordertype->Lookup->renderViewRow($rswrk[0]);
                        $this->ordertype->ViewValue = $this->ordertype->displayValue($arwrk);
                    } else {
                        $this->ordertype->ViewValue = FormatNumber($this->ordertype->CurrentValue, $this->ordertype->formatPattern());
                    }
                }
            } else {
                $this->ordertype->ViewValue = null;
            }

            // invoiced
            $this->invoiced->ViewValue = $this->invoiced->CurrentValue;
            $this->invoiced->ViewValue = FormatNumber($this->invoiced->ViewValue, $this->invoiced->formatPattern());

            // paid
            $this->paid->ViewValue = $this->paid->CurrentValue;
            $this->paid->ViewValue = FormatNumber($this->paid->ViewValue, $this->paid->formatPattern());

            // ordervalue
            $this->ordervalue->ViewValue = $this->ordervalue->CurrentValue;
            $this->ordervalue->ViewValue = FormatNumber($this->ordervalue->ViewValue, $this->ordervalue->formatPattern());

            // jobType
            $this->jobType->ViewValue = $this->jobType->CurrentValue;
            $this->jobType->ViewValue = FormatNumber($this->jobType->ViewValue, $this->jobType->formatPattern());

            // customerid
            $this->customerid->HrefValue = "";

            // bookingdatetime
            $this->bookingdatetime->HrefValue = "";

            // dueby
            $this->dueby->HrefValue = "";

            // ordertype
            $this->ordertype->HrefValue = "";

            // invoiced
            $this->invoiced->HrefValue = "";

            // paid
            $this->paid->HrefValue = "";

            // ordervalue
            $this->ordervalue->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // customerid
            $this->customerid->setupEditAttributes();
            $this->customerid->EditValue = $this->customerid->CurrentValue;
            $curVal = strval($this->customerid->CurrentValue);
            if ($curVal != "") {
                $this->customerid->EditValue = $this->customerid->lookupCacheOption($curVal);
                if ($this->customerid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->customerid->Lookup->getTable()->Fields["customerid"]->searchExpression(), "=", $curVal, $this->customerid->Lookup->getTable()->Fields["customerid"]->searchDataType(), "");
                    $sqlWrk = $this->customerid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->customerid->Lookup->renderViewRow($rswrk[0]);
                        $this->customerid->EditValue = $this->customerid->displayValue($arwrk);
                    } else {
                        $this->customerid->EditValue = HtmlEncode(FormatNumber($this->customerid->CurrentValue, $this->customerid->formatPattern()));
                    }
                }
            } else {
                $this->customerid->EditValue = null;
            }
            $this->customerid->PlaceHolder = RemoveHtml($this->customerid->caption());

            // bookingdatetime
            $this->bookingdatetime->setupEditAttributes();
            $this->bookingdatetime->EditValue = HtmlEncode(FormatDateTime($this->bookingdatetime->CurrentValue, $this->bookingdatetime->formatPattern()));
            $this->bookingdatetime->PlaceHolder = RemoveHtml($this->bookingdatetime->caption());

            // dueby
            $this->dueby->setupEditAttributes();
            $this->dueby->EditValue = HtmlEncode(FormatDateTime($this->dueby->CurrentValue, $this->dueby->formatPattern()));
            $this->dueby->PlaceHolder = RemoveHtml($this->dueby->caption());

            // ordertype
            $this->ordertype->setupEditAttributes();
            $this->ordertype->EditValue = $this->ordertype->CurrentValue;
            $curVal = strval($this->ordertype->CurrentValue);
            if ($curVal != "") {
                $this->ordertype->EditValue = $this->ordertype->lookupCacheOption($curVal);
                if ($this->ordertype->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ordertype->Lookup->getTable()->Fields["ordertypeid"]->searchExpression(), "=", $curVal, $this->ordertype->Lookup->getTable()->Fields["ordertypeid"]->searchDataType(), "");
                    $sqlWrk = $this->ordertype->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ordertype->Lookup->renderViewRow($rswrk[0]);
                        $this->ordertype->EditValue = $this->ordertype->displayValue($arwrk);
                    } else {
                        $this->ordertype->EditValue = HtmlEncode(FormatNumber($this->ordertype->CurrentValue, $this->ordertype->formatPattern()));
                    }
                }
            } else {
                $this->ordertype->EditValue = null;
            }
            $this->ordertype->PlaceHolder = RemoveHtml($this->ordertype->caption());

            // invoiced
            $this->invoiced->setupEditAttributes();
            $this->invoiced->EditValue = $this->invoiced->CurrentValue;
            $this->invoiced->PlaceHolder = RemoveHtml($this->invoiced->caption());
            if (strval($this->invoiced->EditValue) != "" && is_numeric($this->invoiced->EditValue)) {
                $this->invoiced->EditValue = FormatNumber($this->invoiced->EditValue, null);
            }

            // paid
            $this->paid->setupEditAttributes();
            $this->paid->EditValue = $this->paid->CurrentValue;
            $this->paid->PlaceHolder = RemoveHtml($this->paid->caption());
            if (strval($this->paid->EditValue) != "" && is_numeric($this->paid->EditValue)) {
                $this->paid->EditValue = FormatNumber($this->paid->EditValue, null);
            }

            // ordervalue
            $this->ordervalue->setupEditAttributes();
            $this->ordervalue->EditValue = $this->ordervalue->CurrentValue;
            $this->ordervalue->PlaceHolder = RemoveHtml($this->ordervalue->caption());
            if (strval($this->ordervalue->EditValue) != "" && is_numeric($this->ordervalue->EditValue)) {
                $this->ordervalue->EditValue = FormatNumber($this->ordervalue->EditValue, null);
            }

            // jobType
            $this->jobType->setupEditAttributes();
            $this->jobType->EditValue = $this->jobType->CurrentValue;
            $this->jobType->PlaceHolder = RemoveHtml($this->jobType->caption());
            if (strval($this->jobType->EditValue) != "" && is_numeric($this->jobType->EditValue)) {
                $this->jobType->EditValue = FormatNumber($this->jobType->EditValue, null);
            }

            // Add refer script

            // customerid
            $this->customerid->HrefValue = "";

            // bookingdatetime
            $this->bookingdatetime->HrefValue = "";

            // dueby
            $this->dueby->HrefValue = "";

            // ordertype
            $this->ordertype->HrefValue = "";

            // invoiced
            $this->invoiced->HrefValue = "";

            // paid
            $this->paid->HrefValue = "";

            // ordervalue
            $this->ordervalue->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->customerid->Visible && $this->customerid->Required) {
                if (!$this->customerid->IsDetailKey && EmptyValue($this->customerid->FormValue)) {
                    $this->customerid->addErrorMessage(str_replace("%s", $this->customerid->caption(), $this->customerid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->customerid->FormValue)) {
                $this->customerid->addErrorMessage($this->customerid->getErrorMessage(false));
            }
            if ($this->bookingdatetime->Visible && $this->bookingdatetime->Required) {
                if (!$this->bookingdatetime->IsDetailKey && EmptyValue($this->bookingdatetime->FormValue)) {
                    $this->bookingdatetime->addErrorMessage(str_replace("%s", $this->bookingdatetime->caption(), $this->bookingdatetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->bookingdatetime->FormValue, $this->bookingdatetime->formatPattern())) {
                $this->bookingdatetime->addErrorMessage($this->bookingdatetime->getErrorMessage(false));
            }
            if ($this->dueby->Visible && $this->dueby->Required) {
                if (!$this->dueby->IsDetailKey && EmptyValue($this->dueby->FormValue)) {
                    $this->dueby->addErrorMessage(str_replace("%s", $this->dueby->caption(), $this->dueby->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dueby->FormValue, $this->dueby->formatPattern())) {
                $this->dueby->addErrorMessage($this->dueby->getErrorMessage(false));
            }
            if ($this->ordertype->Visible && $this->ordertype->Required) {
                if (!$this->ordertype->IsDetailKey && EmptyValue($this->ordertype->FormValue)) {
                    $this->ordertype->addErrorMessage(str_replace("%s", $this->ordertype->caption(), $this->ordertype->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ordertype->FormValue)) {
                $this->ordertype->addErrorMessage($this->ordertype->getErrorMessage(false));
            }
            if ($this->invoiced->Visible && $this->invoiced->Required) {
                if (!$this->invoiced->IsDetailKey && EmptyValue($this->invoiced->FormValue)) {
                    $this->invoiced->addErrorMessage(str_replace("%s", $this->invoiced->caption(), $this->invoiced->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->invoiced->FormValue)) {
                $this->invoiced->addErrorMessage($this->invoiced->getErrorMessage(false));
            }
            if ($this->paid->Visible && $this->paid->Required) {
                if (!$this->paid->IsDetailKey && EmptyValue($this->paid->FormValue)) {
                    $this->paid->addErrorMessage(str_replace("%s", $this->paid->caption(), $this->paid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->paid->FormValue)) {
                $this->paid->addErrorMessage($this->paid->getErrorMessage(false));
            }
            if ($this->ordervalue->Visible && $this->ordervalue->Required) {
                if (!$this->ordervalue->IsDetailKey && EmptyValue($this->ordervalue->FormValue)) {
                    $this->ordervalue->addErrorMessage(str_replace("%s", $this->ordervalue->caption(), $this->ordervalue->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ordervalue->FormValue)) {
                $this->ordervalue->addErrorMessage($this->ordervalue->getErrorMessage(false));
            }
            if ($this->jobType->Visible && $this->jobType->Required) {
                if (!$this->jobType->IsDetailKey && EmptyValue($this->jobType->FormValue)) {
                    $this->jobType->addErrorMessage(str_replace("%s", $this->jobType->caption(), $this->jobType->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jobType->FormValue)) {
                $this->jobType->addErrorMessage($this->jobType->getErrorMessage(false));
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("OrderdetailGrid");
        if (in_array("orderdetail", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("OrderstagesGrid");
        if (in_array("orderstages", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("OrderarticlesGrid");
        if (in_array("orderarticles", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("OrderdetailGrid");
            if (in_array("orderdetail", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->orderId->setSessionValue($this->orderid->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "orderdetail"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->orderId->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("OrderstagesGrid");
            if (in_array("orderstages", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->orderid->setSessionValue($this->orderid->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "orderstages"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->orderid->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("OrderarticlesGrid");
            if (in_array("orderarticles", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->orderId->setSessionValue($this->orderid->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "orderarticles"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->orderId->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // customerid
        $this->customerid->setDbValueDef($rsnew, $this->customerid->CurrentValue, false);

        // bookingdatetime
        $this->bookingdatetime->setDbValueDef($rsnew, UnFormatDateTime($this->bookingdatetime->CurrentValue, $this->bookingdatetime->formatPattern()), false);

        // dueby
        $this->dueby->setDbValueDef($rsnew, UnFormatDateTime($this->dueby->CurrentValue, $this->dueby->formatPattern()), false);

        // ordertype
        $this->ordertype->setDbValueDef($rsnew, $this->ordertype->CurrentValue, false);

        // invoiced
        $this->invoiced->setDbValueDef($rsnew, $this->invoiced->CurrentValue, false);

        // paid
        $this->paid->setDbValueDef($rsnew, $this->paid->CurrentValue, false);

        // ordervalue
        $this->ordervalue->setDbValueDef($rsnew, $this->ordervalue->CurrentValue, false);

        // jobType
        $this->jobType->setDbValueDef($rsnew, $this->jobType->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['customerid'])) { // customerid
            $this->customerid->setFormValue($row['customerid']);
        }
        if (isset($row['bookingdatetime'])) { // bookingdatetime
            $this->bookingdatetime->setFormValue($row['bookingdatetime']);
        }
        if (isset($row['dueby'])) { // dueby
            $this->dueby->setFormValue($row['dueby']);
        }
        if (isset($row['ordertype'])) { // ordertype
            $this->ordertype->setFormValue($row['ordertype']);
        }
        if (isset($row['invoiced'])) { // invoiced
            $this->invoiced->setFormValue($row['invoiced']);
        }
        if (isset($row['paid'])) { // paid
            $this->paid->setFormValue($row['paid']);
        }
        if (isset($row['ordervalue'])) { // ordervalue
            $this->ordervalue->setFormValue($row['ordervalue']);
        }
        if (isset($row['jobType'])) { // jobType
            $this->jobType->setFormValue($row['jobType']);
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("orderdetail", $detailTblVar)) {
                $detailPageObj = Container("OrderdetailGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->orderId->IsDetailKey = true;
                    $detailPageObj->orderId->CurrentValue = $this->orderid->CurrentValue;
                    $detailPageObj->orderId->setSessionValue($detailPageObj->orderId->CurrentValue);
                }
            }
            if (in_array("orderstages", $detailTblVar)) {
                $detailPageObj = Container("OrderstagesGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->orderid->IsDetailKey = true;
                    $detailPageObj->orderid->CurrentValue = $this->orderid->CurrentValue;
                    $detailPageObj->orderid->setSessionValue($detailPageObj->orderid->CurrentValue);
                }
            }
            if (in_array("orderarticles", $detailTblVar)) {
                $detailPageObj = Container("OrderarticlesGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->orderId->IsDetailKey = true;
                    $detailPageObj->orderId->CurrentValue = $this->orderid->CurrentValue;
                    $detailPageObj->orderId->setSessionValue($detailPageObj->orderId->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("orderslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customerid":
                    break;
                case "x_ordertype":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
