<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "customers" table
 */
#[Entity]
#[Table(name: "customers")]
class Customer extends AbstractEntity
{
    public static array $propertyNames = [
        'customerid' => 'customerid',
        'customername' => 'customername',
        'address' => 'address',
        'ParentAgent' => 'parentAgent',
        'isAgent' => 'isAgent',
        'priceListId' => 'priceListId',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $customerid;

    #[Column(type: "string")]
    private string $customername;

    #[Column(type: "string")]
    private string $address;

    #[Column(name: "ParentAgent", type: "integer", nullable: true)]
    private ?int $parentAgent;

    #[Column(type: "integer", nullable: true)]
    private ?int $isAgent;

    #[Column(type: "integer", nullable: true)]
    private ?int $priceListId;

    public function getCustomerid(): int
    {
        return $this->customerid;
    }

    public function setCustomerid(int $value): static
    {
        $this->customerid = $value;
        return $this;
    }

    public function getCustomername(): string
    {
        return HtmlDecode($this->customername);
    }

    public function setCustomername(string $value): static
    {
        $this->customername = RemoveXss($value);
        return $this;
    }

    public function getAddress(): string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getParentAgent(): ?int
    {
        return $this->parentAgent;
    }

    public function setParentAgent(?int $value): static
    {
        $this->parentAgent = $value;
        return $this;
    }

    public function getIsAgent(): ?int
    {
        return $this->isAgent;
    }

    public function setIsAgent(?int $value): static
    {
        $this->isAgent = $value;
        return $this;
    }

    public function getPriceListId(): ?int
    {
        return $this->priceListId;
    }

    public function setPriceListId(?int $value): static
    {
        $this->priceListId = $value;
        return $this;
    }
}
