<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "pricelistsdetails" table
 */
#[Entity]
#[Table(name: "pricelistsdetails")]
class Pricelistsdetail extends AbstractEntity
{
    public static array $propertyNames = [
        'priceListDetailId' => 'priceListDetailId',
        'priceListid' => 'priceListid',
        'articleid' => 'articleid',
        'rate' => 'rate',
        'discount' => 'discount',
        'discountType' => 'discountType',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $priceListDetailId;

    #[Column(type: "integer")]
    private int $priceListid;

    #[Column(type: "integer")]
    private int $articleid;

    #[Column(type: "float")]
    private float $rate;

    #[Column(type: "float")]
    private float $discount;

    #[Column(type: "integer")]
    private int $discountType;

    public function getPriceListDetailId(): int
    {
        return $this->priceListDetailId;
    }

    public function setPriceListDetailId(int $value): static
    {
        $this->priceListDetailId = $value;
        return $this;
    }

    public function getPriceListid(): int
    {
        return $this->priceListid;
    }

    public function setPriceListid(int $value): static
    {
        $this->priceListid = $value;
        return $this;
    }

    public function getArticleid(): int
    {
        return $this->articleid;
    }

    public function setArticleid(int $value): static
    {
        $this->articleid = $value;
        return $this;
    }

    public function getRate(): float
    {
        return $this->rate;
    }

    public function setRate(float $value): static
    {
        $this->rate = $value;
        return $this;
    }

    public function getDiscount(): float
    {
        return $this->discount;
    }

    public function setDiscount(float $value): static
    {
        $this->discount = $value;
        return $this;
    }

    public function getDiscountType(): int
    {
        return $this->discountType;
    }

    public function setDiscountType(int $value): static
    {
        $this->discountType = $value;
        return $this;
    }
}
