<?php

namespace PHPMaker2024\laundrytech;

// Page object
$AgentsEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fagentsedit" id="fagentsedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { agents: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fagentsedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fagentsedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["agentid", [fields.agentid.visible && fields.agentid.required ? ew.Validators.required(fields.agentid.caption) : null], fields.agentid.isInvalid],
            ["agentname", [fields.agentname.visible && fields.agentname.required ? ew.Validators.required(fields.agentname.caption) : null], fields.agentname.isInvalid],
            ["agentaddress", [fields.agentaddress.visible && fields.agentaddress.required ? ew.Validators.required(fields.agentaddress.caption) : null], fields.agentaddress.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="agents">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->agentid->Visible) { // agentid ?>
    <div id="r_agentid"<?= $Page->agentid->rowAttributes() ?>>
        <label id="elh_agents_agentid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agentid->caption() ?><?= $Page->agentid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agentid->cellAttributes() ?>>
<span id="el_agents_agentid">
<span<?= $Page->agentid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->agentid->getDisplayValue($Page->agentid->EditValue))) ?>"></span>
<input type="hidden" data-table="agents" data-field="x_agentid" data-hidden="1" name="x_agentid" id="x_agentid" value="<?= HtmlEncode($Page->agentid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->agentname->Visible) { // agentname ?>
    <div id="r_agentname"<?= $Page->agentname->rowAttributes() ?>>
        <label id="elh_agents_agentname" for="x_agentname" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agentname->caption() ?><?= $Page->agentname->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agentname->cellAttributes() ?>>
<span id="el_agents_agentname">
<input type="<?= $Page->agentname->getInputTextType() ?>" name="x_agentname" id="x_agentname" data-table="agents" data-field="x_agentname" value="<?= $Page->agentname->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->agentname->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->agentname->formatPattern()) ?>"<?= $Page->agentname->editAttributes() ?> aria-describedby="x_agentname_help">
<?= $Page->agentname->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->agentname->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->agentaddress->Visible) { // agentaddress ?>
    <div id="r_agentaddress"<?= $Page->agentaddress->rowAttributes() ?>>
        <label id="elh_agents_agentaddress" for="x_agentaddress" class="<?= $Page->LeftColumnClass ?>"><?= $Page->agentaddress->caption() ?><?= $Page->agentaddress->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->agentaddress->cellAttributes() ?>>
<span id="el_agents_agentaddress">
<input type="<?= $Page->agentaddress->getInputTextType() ?>" name="x_agentaddress" id="x_agentaddress" data-table="agents" data-field="x_agentaddress" value="<?= $Page->agentaddress->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->agentaddress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->agentaddress->formatPattern()) ?>"<?= $Page->agentaddress->editAttributes() ?> aria-describedby="x_agentaddress_help">
<?= $Page->agentaddress->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->agentaddress->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fagentsedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fagentsedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("agents");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
