<?php

namespace PHPMaker2024\laundrytech;

// Page object
$CustomersView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fcustomersview" id="fcustomersview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcustomersview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomersview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customers">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->customerid->Visible) { // customerid ?>
    <tr id="r_customerid"<?= $Page->customerid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_customerid"><?= $Page->customerid->caption() ?></span></td>
        <td data-name="customerid"<?= $Page->customerid->cellAttributes() ?>>
<span id="el_customers_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<?= $Page->customerid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->customername->Visible) { // customername ?>
    <tr id="r_customername"<?= $Page->customername->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_customername"><?= $Page->customername->caption() ?></span></td>
        <td data-name="customername"<?= $Page->customername->cellAttributes() ?>>
<span id="el_customers_customername">
<span<?= $Page->customername->viewAttributes() ?>>
<?= $Page->customername->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <tr id="r_address"<?= $Page->address->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_address"><?= $Page->address->caption() ?></span></td>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el_customers_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
    <tr id="r_ParentAgent"<?= $Page->ParentAgent->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_ParentAgent"><?= $Page->ParentAgent->caption() ?></span></td>
        <td data-name="ParentAgent"<?= $Page->ParentAgent->cellAttributes() ?>>
<span id="el_customers_ParentAgent">
<span<?= $Page->ParentAgent->viewAttributes() ?>>
<?= $Page->ParentAgent->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->isAgent->Visible) { // isAgent ?>
    <tr id="r_isAgent"<?= $Page->isAgent->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_isAgent"><?= $Page->isAgent->caption() ?></span></td>
        <td data-name="isAgent"<?= $Page->isAgent->cellAttributes() ?>>
<span id="el_customers_isAgent">
<span<?= $Page->isAgent->viewAttributes() ?>>
<?= $Page->isAgent->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->priceListId->Visible) { // priceListId ?>
    <tr id="r_priceListId"<?= $Page->priceListId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customers_priceListId"><?= $Page->priceListId->caption() ?></span></td>
        <td data-name="priceListId"<?= $Page->priceListId->cellAttributes() ?>>
<span id="el_customers_priceListId">
<span<?= $Page->priceListId->viewAttributes() ?>>
<?= $Page->priceListId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php
    if (in_array("customerhasarticles", explode(",", $Page->getCurrentDetailTable())) && $customerhasarticles->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("customerhasarticles", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "CustomerhasarticlesGrid.php" ?>
<?php } ?>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
