<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class LaundrytechUsersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/laundrytechuserslist[/{ID}]", [PermissionMiddleware::class], "list.laundrytech_users")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUsersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/laundrytechusersadd[/{ID}]", [PermissionMiddleware::class], "add.laundrytech_users")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUsersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/laundrytechusersview[/{ID}]", [PermissionMiddleware::class], "view.laundrytech_users")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUsersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/laundrytechusersedit[/{ID}]", [PermissionMiddleware::class], "edit.laundrytech_users")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUsersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/laundrytechusersdelete[/{ID}]", [PermissionMiddleware::class], "delete.laundrytech_users")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechUsersDelete");
    }
}
