<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class AgentsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/agentslist[/{agentid}]", [PermissionMiddleware::class], "list.agents")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/agentsadd[/{agentid}]", [PermissionMiddleware::class], "add.agents")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/agentsview[/{agentid}]", [PermissionMiddleware::class], "view.agents")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/agentsedit[/{agentid}]", [PermissionMiddleware::class], "edit.agents")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/agentsdelete[/{agentid}]", [PermissionMiddleware::class], "delete.agents")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "AgentsDelete");
    }
}
