<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class RunsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/runslist[/{runid}]", [PermissionMiddleware::class], "list.runs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RunsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/runsadd[/{runid}]", [PermissionMiddleware::class], "add.runs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RunsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/runsview[/{runid}]", [PermissionMiddleware::class], "view.runs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RunsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/runsedit[/{runid}]", [PermissionMiddleware::class], "edit.runs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RunsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/runsdelete[/{runid}]", [PermissionMiddleware::class], "delete.runs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RunsDelete");
    }
}
