<?php

namespace PHPMaker2024\laundrytech;

// Page object
$ArticlesView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="farticlesview" id="farticlesview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { articles: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var farticlesview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("farticlesview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="articles">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->articleid->Visible) { // articleid ?>
    <tr id="r_articleid"<?= $Page->articleid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_articleid"><?= $Page->articleid->caption() ?></span></td>
        <td data-name="articleid"<?= $Page->articleid->cellAttributes() ?>>
<span id="el_articles_articleid">
<span<?= $Page->articleid->viewAttributes() ?>>
<?= $Page->articleid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->articlename1->Visible) { // articlename1 ?>
    <tr id="r_articlename1"<?= $Page->articlename1->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_articlename1"><?= $Page->articlename1->caption() ?></span></td>
        <td data-name="articlename1"<?= $Page->articlename1->cellAttributes() ?>>
<span id="el_articles_articlename1">
<span<?= $Page->articlename1->viewAttributes() ?>>
<?= $Page->articlename1->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->articlename2->Visible) { // articlename2 ?>
    <tr id="r_articlename2"<?= $Page->articlename2->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_articlename2"><?= $Page->articlename2->caption() ?></span></td>
        <td data-name="articlename2"<?= $Page->articlename2->cellAttributes() ?>>
<span id="el_articles_articlename2">
<span<?= $Page->articlename2->viewAttributes() ?>>
<?= $Page->articlename2->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->categoryid->Visible) { // categoryid ?>
    <tr id="r_categoryid"<?= $Page->categoryid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_categoryid"><?= $Page->categoryid->caption() ?></span></td>
        <td data-name="categoryid"<?= $Page->categoryid->cellAttributes() ?>>
<span id="el_articles_categoryid">
<span<?= $Page->categoryid->viewAttributes() ?>>
<?= $Page->categoryid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
    <tr id="r_weight"<?= $Page->weight->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_weight"><?= $Page->weight->caption() ?></span></td>
        <td data-name="weight"<?= $Page->weight->cellAttributes() ?>>
<span id="el_articles_weight">
<span<?= $Page->weight->viewAttributes() ?>>
<?= $Page->weight->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->owned->Visible) { // owned ?>
    <tr id="r_owned"<?= $Page->owned->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_articles_owned"><?= $Page->owned->caption() ?></span></td>
        <td data-name="owned"<?= $Page->owned->cellAttributes() ?>>
<span id="el_articles_owned">
<span<?= $Page->owned->viewAttributes() ?>>
<?= $Page->owned->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
